<?php
/*
 * This file is used to generate WordPress standard archive/category pages.
 */
	get_header ();
	
	/* Get Default Option for Archives, Category, Search. */
	$wecare_num_excerpt = '';
	$wecare_default_settings = get_option('default_pages_settings');
	
	if($wecare_default_settings != ''){
		$wecare_default = new DOMDocument ();
		$wecare_default->loadXML ( $wecare_default_settings );
		$wecare_sidebar = wecare_find_xml_value($wecare_default->documentElement,'sidebar_default');
		$wecare_right_sidebar = wecare_find_xml_value($wecare_default->documentElement,'right_sidebar_default');
		$wecare_left_sidebar = wecare_find_xml_value($wecare_default->documentElement,'left_sidebar_default');
		$wecare_num_excerpt = wecare_find_xml_value($wecare_default->documentElement,'default_excerpt');
		
	}	
	/* Get Default Excerpt */
	$wecare_num_excerpt = 250;

	if(empty($paged)){
		$paged = (get_query_var('page')) ? get_query_var('page') : 1; 
	}
	
	$wecare_sidebar_class = '';
	$wecare_content_class = '';
		
	/* Get Sidebar for page */
	$wecare_sidebar_class = wecare_sidebar_func($wecare_sidebar);
	$wecare_breadcrumbs = '';
	$wecare_breadcrumbs = wecare_get_themeoption_value('breadcrumbs','general_settings');
?>
	<div id="inner-banner">
		<div class="container">
		     <?php /* Only if it is search page */
				if (is_search()) { ?>
					<h1><?php esc_html_e('Searched', 'wecare'); ?> : <?php echo esc_attr(get_search_query()); ?></h1>
					<em><?php esc_html_e('All Searched Results Listed Here On This Page.','wecare');?></em>
			<?php } ?>
		</div>
	</div>

	<div id="main"> 
		<section class="blog-style-1 blog-space search_page">
			<div class="container">
				<div class="row">
					<?php /* Sidebar Settings */
						if($wecare_sidebar == "left-sidebar" || $wecare_sidebar == "both-sidebar" || $wecare_sidebar == "both-sidebar-left"){?>
							<div id="block_first" class="sidebar side-bar <?php echo esc_attr($wecare_sidebar_class[0]);?>">
								<aside>
									<div class="cp-sidebar">
										<?php dynamic_sidebar( $wecare_left_sidebar ); ?>
									</div>
								</aside>
							</div>
							<?php
						}
						if($wecare_sidebar == 'both-sidebar-left'){?>
							<div id="block_first_left" class="sidebar side-bar <?php echo esc_attr($wecare_sidebar_class[0]);?>">
								<aside>
									<div class="cp-sidebar">
										<?php dynamic_sidebar( $wecare_right_sidebar );?>
									</div>
								</aside>
							</div>
						<?php 
						} 
					?>
					
					<div id="search-<?php the_ID(); ?>" class="blog_listing blog-home <?php echo esc_attr($wecare_sidebar_class[1]);?>">						
						<?php /* Loop */
							if ( have_posts() ) { 
	
								while ( have_posts() ) : the_post(); global $post; 
							
									/* Get Comment Count */
									$comment_count = wp_count_comments( $post->ID );
									
									$comment_count = $comment_count->total_comments; ?>
									
								<div class="cp_search_page">
									<div <?php post_class(); ?>>
										
											<div class="style-1">
												<div class="frame">
													<a href="<?php echo esc_url(get_the_permalink());?>"><?php echo get_the_post_thumbnail($post->ID, 'full'); ?></a>
													<?php /* if Sticky Add Sticky Message */
													if(is_sticky($post->ID)){ ?>
														<strong class="sticky"><?php esc_html_e('Sticky Post','wecare');?></strong>
													<?php
													} ?>										
												</div>
												<div class="text-box">
													<div class="clearfix">
													  <div class="thumb"><?php echo get_avatar( get_the_author_meta( 'ID' ), 60 );?></div>
													  <div class="btn-row"> 
														<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ));?>" class="link"><i class="fa fa-user" aria-hidden="true"></i><?php echo esc_attr(get_the_author());?></a> 
														<a href="<?php echo esc_url(get_the_permalink());?>" class="link"><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo esc_attr(get_the_date());?></a> 
													  </div>
													</div>
													<h3><a href="<?php echo esc_url(get_the_permalink());?>"><?php echo esc_attr(get_the_title());?></a></h3>
													<div class = "the-content">
														<?php /* Content */
															the_content();
															wp_link_pages( array(
																'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'wecare' ) . '</span>',
																'after'       => '</div>',
																'link_before' => '<span>',
																'link_after'  => '</span>',
																'pagelink'    => '<span class="screen-reader-text"></span>%',
																'separator'   => '<span class="screen-reader-text"></span>',
															) );
															?>
													</div>
													<a href="<?php echo esc_url(get_the_permalink());?>" class="btn-more"><?php esc_html_e('Read Details','wecare');?></a> 	
												</div>
											</div>
										
									</div>
								</div>
									<?php 
								endwhile; /* endwhile */
							}else{ ?>
							
							<section class="error-section">
							  <div class="element_wrap">
								<div class="holder"> 
									<span class="title"><?php esc_html_e('Oops!','wecare');?></span>
									<strong class="title"><?php esc_html_e('404','wecare');?></strong>
									<form method="get" action="<?php  echo esc_url(home_url('/')); ?>">
										<input type="text" placeholder="<?php esc_html_e('Enter your words for search again','wecare');?>" value="<?php the_search_query(); ?>" name="s"  autocomplete="off" />
										<button type="submit" value="<?php esc_html_e('Search','wecare');?>"><i class="fa fa-search"></i></button>
										<div class="btn-row"><a href="<?php  echo esc_url(home_url('/')); ?>" class="btn-style-1"><?php esc_html_e('Back Home','wecare');?></a></div>
									</form>
								</div>
							  </div>
							</section>
							
								<?php 
							} ?>
					</div>
					<?php /* Sidebar Settings */
						if($wecare_sidebar == "both-sidebar-right"){?>
							<div class="<?php echo esc_attr($wecare_sidebar_class[0]);?> side-bar">
								<aside>
									<div class="cp-sidebar">
										<?php dynamic_sidebar( $wecare_left_sidebar ); ?>
									</div>
								</aside>
							</div>
							<?php
						}
						if($wecare_sidebar == 'both-sidebar-right' || $wecare_sidebar == "right-sidebar" || $wecare_sidebar == "both-sidebar"){?>
							<div class="<?php echo esc_attr($wecare_sidebar_class[0]);?> side-bar">
								<aside>
									<div class="cp-sidebar">
										<?php dynamic_sidebar( $wecare_right_sidebar ); ?>
									</div>
								</aside>
							</div>
						<?php 
						} ?>	
						
						<div class="pagination-box">
							<nav>
								<ul class="pagination">
									<li>
										<?php echo wecare_pagination();?>
									</li>
								</ul>
							</nav>
						</div>
				</div>	
			</div>
		</section>
	</div>
<?php get_footer(); ?>