<?php

	/*	
	*	Crunchpress Function Registered File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		Crunchpress
	* 	@link		http://crunchpress.com
	* 	@copyright	Copyright (c) Crunchpress
	*	---------------------------------------------------------------------
	*	This file use to register the wordpress function to the framework,
	*	and also use filter to hook some necessary events.
	*	---------------------------------------------------------------------
	*/
	
	
	if (function_exists('register_sidebar')){	
	
		/* default sidebar array */
		$wecare_sidebar_attr = array(
			'name' => '',
			'description' => '',
			'before_widget' => '<div class="widget sidebar-recent-post sidebar_section %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h3>',
			'after_title' => '</h3>'
		);

			
		$wecare_footer_col_layout = '';
		$wecare_footer_col_layout = wecare_get_themeoption_value('footer_col_layout','general_settings');
		
		$wecare_sidebar_id = 0;
		$wecare_sidebar = array();
		
		/* Print Footer Widget Areas */
		$wecare_select_footer_cp = wecare_get_themeoption_value('select_footer_cp','general_settings');
		$wecare_select_footer_cp = 'Style 1';

		
		if($wecare_select_footer_cp == 'Style 1'){
			$wecare_sidebar = array("Footer");
			$wecare_sidebar_upper = array("Twitter");
		}else if($wecare_select_footer_cp == 'Style 6'){
			$wecare_sidebar = array();
			$wecare_sidebar_upper = array("Twitter");
		}else{
			$wecare_sidebar = array("Footer");
			$wecare_sidebar_upper = array();
		}
		
		/* Home Page Layout */
		if($wecare_footer_col_layout == 'footer-style1'){
			
			foreach( $wecare_sidebar as $sidebar_name ){
				$wecare_sidebar_attr['name'] = $sidebar_name;
				$sidebar_slug = strtolower(str_replace(' ','-',$sidebar_name));
				$wecare_sidebar_attr['id'] = 'sidebar-' . $sidebar_slug ;
				$wecare_sidebar_attr['before_widget'] = '<div class="col-md-3 col-sm-6"><div class="widget footer-box box %2$s">' ;
				$wecare_sidebar_attr['before_title'] = '<h3>' ;
				$wecare_sidebar_attr['after_widget'] = '</div></div>' ;
				$wecare_sidebar_attr['after_title'] = '</h3>' ;
				$wecare_sidebar_attr['description'] = esc_html__('Please Place Widgets Here','wecare') ;				
				register_sidebar($wecare_sidebar_attr);
			}
		
		}else{
			
			foreach( $wecare_sidebar as $sidebar_name ){
				$wecare_sidebar_attr['name'] = $sidebar_name;
				$sidebar_slug = strtolower(str_replace(' ','-',$sidebar_name));
				$wecare_sidebar_attr['id'] = 'sidebar-' . $sidebar_slug ;
				$wecare_sidebar_attr['before_widget'] = '<div class="col-md-4 col-sm-6"><div class="widget box-1 box %2$s">' ;
				$wecare_sidebar_attr['after_widget'] = '</div></div>' ;
				$wecare_sidebar_attr['before_title'] = '<h3>';
				$wecare_sidebar_attr['after_title'] = '</h3>' ;
				$wecare_sidebar_attr['description'] = esc_html__('Please Place Widgets Here','wecare') ;
				register_sidebar($wecare_sidebar_attr);
			}
		}

		$wecare_footer_upper_layout = wecare_get_themeoption_value('footer_upper_layout','general_settings');
	  
		/* Home Page Layout */
		if($wecare_footer_upper_layout == 'footer-style-upper-1'){
			
			foreach( $wecare_sidebar_upper as $sidebar_name ){
				$wecare_sidebar_attr['name'] = $sidebar_name;
				$sidebar_slug = strtolower(str_replace(' ','-',$sidebar_name));
				$wecare_sidebar_attr['id'] = 'sidebar-' . $sidebar_slug ;
				$wecare_sidebar_attr['before_widget'] = '<div class="widget %2$s">' ;
				$wecare_sidebar_attr['after_widget'] = '</div>' ;
				$wecare_sidebar_attr['before_title'] = '<div class="container"><h3>';
				$wecare_sidebar_attr['after_title'] = '</h3></div>' ;
				$wecare_sidebar_attr['description'] = esc_html__('Please Place Widgets Here','wecare') ;				
				register_sidebar($wecare_sidebar_attr);
			}
		
		}else{
			
			foreach( $wecare_sidebar_upper as $sidebar_name ){
				$wecare_sidebar_attr['name'] = $sidebar_name;
				$sidebar_slug = strtolower(str_replace(' ','-',$sidebar_name));
				$wecare_sidebar_attr['id'] = 'sidebar-' . $sidebar_slug ;
				$wecare_sidebar_attr['before_widget'] = '<div class="%2$s">' ;
				$wecare_sidebar_attr['after_widget'] = '</div>' ;
				$wecare_sidebar_attr['before_title'] = '<div class="container"><h3>';
				$wecare_sidebar_attr['after_title'] = '</h3></div>' ;
				$wecare_sidebar_attr['description'] = esc_html__('Please Place Widgets Here','wecare') ;
				register_sidebar($wecare_sidebar_attr);
			}
		}			
		

		$wecare_sidebar = '';
		$wecare_sidebar = get_option('sidebar_settings');
		
		
		if(!empty($wecare_sidebar)){
			$wecare_xml = new DOMDocument();
			$wecare_xml->loadXML($wecare_sidebar);
			foreach( $wecare_xml->documentElement->childNodes as $sidebar_name ){
				$wecare_sidebar_attr['name'] = $sidebar_name->nodeValue;
				$wecare_sidebar_attr['id'] = 'custom-sidebar' . $wecare_sidebar_id++ ;
				$wecare_sidebar_attr['before_widget'] = '<div class="widget sidebar-box sidebar-recent-post %2$s">' ;
				$wecare_sidebar_attr['after_widget'] = '</div>' ;
				$wecare_sidebar_attr['before_title'] = '<h3>' ;
				$wecare_sidebar_attr['after_title'] = '</h3>' ;
				register_sidebar($wecare_sidebar_attr);
			}
		}

	}
	
	
	/* Add Theme Support */
	if(function_exists('add_theme_support')){
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		*/
		 
		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list',) );

		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		 
		add_theme_support( 'post-formats', array('aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery') );
		
		/* enable featured image */
		
		add_theme_support('post-thumbnails');
		
		/*  enable editor style */
		
		add_editor_style('editor-style.css');
		
		/* enable navigation menu */
		add_theme_support('menus');
		
		register_nav_menus(array('header-menu'=>'Header Menu'));
		
		add_theme_support( 'title-tag' );
	}
	
	/* add filter to hook when user press "insert into post" to include the attachment id */
	add_filter('media_send_to_editor', 'wecare_add_para_media_to_editor', 20, 2);
	
	function wecare_add_para_media_to_editor($html, $id){

		if(strpos($html, 'href')){
			$pos = strpos($html, '<a') + 2;
			$html = substr($html, 0, $pos) . ' attid="' . $id . '" ' . substr($html, $pos);
		}
		
		return $html ;
		
	}
	
	/* enable theme to support the localization */
	add_action('init', 'wecare_word_translation');
	
	function wecare_word_translation(){
		
		load_theme_textdomain( 'wecare', get_template_directory() . '/languages/' );		
	}

	/*  excerpt filter */
	add_filter('excerpt_length','wecare_excerpt_length');
	
	function wecare_excerpt_length(){
		
		return 250;
	}
	
	add_action('wp_footer', 'wecare_add_javascript_code');
	
	/* Javascript Code */
	function wecare_add_javascript_code(){
		$wecare_javascript_code = '';
		/* Get Options */
		$wecare_general_settings = get_option('general_settings');
		if($wecare_general_settings <> ''){
			$wecare_logo = new DOMDocument ();
			$wecare_logo->loadXML ( $wecare_general_settings );
			$wecare_javascript_code = wecare_find_xml_value($wecare_logo->documentElement,'wecare_javascript_code');
			}
		echo esc_js($wecare_javascript_code);
	
	}
	
	add_action('wp_footer', 'wecare_add_header_code');
	
	/* Header Style or Script */
	function wecare_add_header_code(){
		$wecare_header_css_code = '';
		/* Get Options */
		$wecare_general_settings = get_option('general_settings');
		if($wecare_general_settings <> ''){
			$wecare_logo = new DOMDocument ();
			$wecare_logo->loadXML ( $wecare_general_settings );
			$wecare_header_css_code = wecare_find_xml_value($wecare_logo->documentElement,'header_css_code');
		}
		echo esc_attr($wecare_header_css_code);
	}
	
	/* Typekit Code */
	add_action('wp_footer', 'wecare_add_typekit_code');

	function wecare_add_typekit_code(){
		$wecare_embed_typekit_code = '';
		$wecare_typography_settings = get_option('typography_settings');
		if($wecare_typography_settings <> ''){
			$wecare_typo = new DOMDocument ();
			$wecare_typo->loadXML ( $wecare_typography_settings );
			$wecare_embed_typekit_code = wecare_find_xml_value($wecare_typo->documentElement,'embed_typekit_code');
		}
		echo esc_attr($wecare_embed_typekit_code);
	
	}
	
	/* Custom Post type Feed */
	add_filter('request', 'wecare_myfeed_request');
	function wecare_myfeed_request($qv) {
		
		if (isset($qv['feed']) && !isset($qv['post_type']))
		$qv['post_type'] = array('post'); /* array('post','team') */
		return $qv;
	}

	/* Translate the wpml shortcode */
	function wecare_webtreats_lang_test( $atts, $content = null ) {
		extract(shortcode_atts(array( 'lang' => '' ), $atts));
		
		$wecare_lang_active = ICL_LANGUAGE_CODE;
		
		if($lang == $wecare_lang_active){
			return $content;
		}
	}
	
	/*  Add Another theme support */
	add_theme_support( 'automatic-feed-links' );	
	
	if ( ! isset( $content_width ) ){ $content_width = 980; }
	
	if ( ! isset( $wecare_content_width ) ){ $wecare_content_width = 980; }
	
	/* update the option if new value is exists and not equal to old one  */
	function wecare_save_option($wecare_name, $wecare_old_value, $wecare_new_value){
	
		if(empty($wecare_new_value) && !empty($wecare_old_value)){
		
			if(!delete_option($wecare_name)){
			
				return false;
				
			}
			
		}else if($wecare_old_value != $wecare_new_value){
		
			if(!update_option($wecare_name, $wecare_new_value)){
			
				return false;
				
			}
			
		}
		
		return true;
	}
	
	
	/* Add Newsletter Table */
	function wecare_add_newsletter_table() {
		global $wpdb;
		$wpdb->query("
			CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."wecare_newsletter` (
			  `name` varchar(100) NOT NULL,
			  `email` varchar(100) NOT NULL,
			  `ip` varchar(16) NOT NULL,
			  `date_time` datetime NOT NULL
			) ENGINE=InnoDB DEFAULT CHARSET=latin1;
		");
	}
	
	
	/* Flush rewrite rules for custom post types. */
		global $pagenow;
		if ( 'themes.php' == $pagenow && isset( $_GET['activated'] ) ){
			
			add_action('init', 'wecare_add_newsletter_table');	
			
			if(get_option('default_pages_settings') == ''){$default_pages_xml = "<default_pages_settings><sidebar_default>right-sidebar</sidebar_default><right_sidebar_default>Post Sidebar</right_sidebar_default><left_sidebar_default>Post Sidebar</left_sidebar_default><default_excerpt>150</default_excerpt></default_pages_settings>";save_option('default_pages_settings', get_option('default_pages_settings'),$default_pages_xml);}if(get_option('general_settings') == ''){$general_settings = "<general_settings><header_logo_btn>enable</header_logo_btn><header_logo_bg></header_logo_bg><logo_text_cp>We Care</logo_text_cp><logo_subtext>Charity WordPress Theme</logo_subtext><header_logo></header_logo><logo_width>202</logo_width><logo_height>58</logo_height><select_layout_cp></select_layout_cp><boxed_scheme></boxed_scheme><color_scheme>#e53935</color_scheme><body_color></body_color><heading_color></heading_color><select_bg_pat>Background-Color</select_bg_pat><bg_scheme>#ffffff</bg_scheme><body_patren></body_patren><color_patren></color_patren><body_image></body_image><position_image_layout>top</position_image_layout><image_repeat_layout>no-repeat</image_repeat_layout><image_attachment_layout>fixed</image_attachment_layout><sign_up>#</sign_up><sign_in>#</sign_in><header_get_quote_link>#</header_get_quote_link><topbar_content></topbar_content><contact_us_code></contact_us_code><mailto></mailto><select_header_cp>Style 1</select_header_cp><header_style_apply>disable</header_style_apply><topsocial_icon></topsocial_icon><header_address_field></header_address_field><header_contact_text></header_contact_text><cart_btn>enable</cart_btn><search_btn>enable</search_btn><beamember_btn>+44 1234 567</beamember_btn><volunteer_text></volunteer_text><volunteer_page_link>info@example.com</volunteer_page_link><make_donation_link>#</make_donation_link><copyright_code>We Care 2017, All Rights Reserved, Design &amp; Developed By: CrunchPress</copyright_code><select_footer_cp></select_footer_cp><footer_style_apply></footer_style_apply><footer_bg></footer_bg><footer_col_layout>footer-style1</footer_col_layout><footer_upper_layout></footer_upper_layout><social_networking>enable</social_networking><newsletter_mailpoet_ID>We Care have many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which look even slightly believable. If you are going to use a passage of Lorem Ipsum...</newsletter_mailpoet_ID><newsletter_title>http://crunchpress.com/dummy/wecare/wp-content/uploads/2017/02/footer-logo.png</newsletter_title><street_address>More About WeCare</street_address><location_address></location_address><email_address>#</email_address><footer_contact_number></footer_contact_number><skype_address></skype_address><footer_website></footer_website><footer_logo></footer_logo><footer_description></footer_description><footer_4_title1></footer_4_title1><footer_4_title2></footer_4_title2><footer_4_title3></footer_4_title3><footer_4_desc1></footer_4_desc1><footer_4_desc2></footer_4_desc2><footer_4_desc3></footer_4_desc3><footer_4_link1></footer_4_link1><footer_4_link2></footer_4_link2><footer_4_link3></footer_4_link3><google_map_api></google_map_api><breadcrumbs>enable</breadcrumbs><rtl_layout></rtl_layout><charity_page>2</charity_page><charity_color>#826455</charity_color><politics_page>2</politics_page><politics_color>#82b441</politics_color><wecare_maintenance_mode_swtich>enable</wecare_maintenance_mode_swtich><wecare_maintenace_title>We Are Under Construction</wecare_maintenace_title><wecare_countdown_time>March 24, 2018</wecare_countdown_time><wecare_email_maintenance>example@example.com</wecare_email_maintenance><wecare_mainte_description>COMING SOON</wecare_mainte_description><wecare_social_icons_maintenance>1</wecare_social_icons_maintenance></general_settings>";save_option('general_settings', get_option('general_settings'),$general_settings);}if(get_option('typography_settings') == ''){$typography_settings = "<typography_settings><font_google>Open Sans</font_google><font_size_normal>14</font_size_normal><font_google_heading>Default</font_google_heading><menu_font_google>Default</menu_font_google><heading_h1>48</heading_h1><heading_h2>32</heading_h2><heading_h3>22</heading_h3><heading_h4>18</heading_h4><heading_h5>18</heading_h5><heading_h6>16</heading_h6><embed_typekit_code></embed_typekit_code></typography_settings>";save_option('typography_settings', get_option('typography_settings'),$typography_settings);}if(get_option('slider_settings') == ''){$slider_settings = "<slider_settings><select_slider>bx_slider</select_slider><bx_slider_settings><slide_order_bx>slide</slide_order_bx><auto_play_bx>enable</auto_play_bx><pause_on_bx>enable</pause_on_bx><animation_speed_bx>1500</animation_speed_bx><show_bullets>enable</show_bullets><show_arrow>enable</show_arrow><video_slider_on_off></video_slider_on_off><video_banner_url></video_banner_url><video_banner_caption></video_banner_caption><video_banner_title></video_banner_title><safari_banner></safari_banner><safari_banner_link></safari_banner_link><safari_banner_width></safari_banner_width><safari_banner_height></safari_banner_height></bx_slider_settings></slider_settings>";save_option('slider_settings', get_option('slider_settings'),$slider_settings);}if(get_option('social_settings') == ''){$social_settings = "<social_settings><facebook_network>http://facebook.com</facebook_network><twitter_network>http://twitter.com</twitter_network><delicious_network></delicious_network><google_plus_network>https://plus.google.com/</google_plus_network><dribble_network></dribble_network><linked_in_network>http://linkedin.com</linked_in_network><youtube_network></youtube_network><flickr_network></flickr_network><vimeo_network></vimeo_network><pinterest_network></pinterest_network><Instagram_network></Instagram_network><github_network></github_network><skype_network></skype_network><facebook_sharing>enable</facebook_sharing><twitter_sharing>enable</twitter_sharing><stumble_sharing>disable</stumble_sharing><delicious_sharing>enable</delicious_sharing><googleplus_sharing>enable</googleplus_sharing><digg_sharing>disable</digg_sharing><myspace_sharing>enable</myspace_sharing><reddit_sharing>enable</reddit_sharing></social_settings>";save_option('social_settings', get_option('social_settings'),$social_settings);}if(get_option('sidebar_settings') == ''){$sidebar_settings = "<sidebar_settings><sidebar_name>Post Sidebar</sidebar_name><sidebar_name>Default Sidebar</sidebar_name><sidebar_name>Project Sidebar</sidebar_name><sidebar_name>Events Sidebar</sidebar_name><sidebar_name>Causes Sidebar</sidebar_name></sidebar_settings>";save_option('sidebar_settings', get_option('sidebar_settings'),$sidebar_settings);}
		}

	/* Custom background Support */
	$args = array(
		'default-color'          => '',
		'default-image'          => '',
		'wp-head-callback'       => '_custom_background_cb',
		'admin-head-callback'    => '',
		'admin-preview-callback' => ''
	);

	/* Custom Header Support */
	$defaults = array(
		'default-image'          => '',
		'random-default'         => false,
		'width'                  => 950,
		'height'                 => 200,
		'flex-height'            => false,
		'flex-width'             => false,
		'default-text-color'     => '',
		'header-text'            => true,
		'uploads'                => true,
		'wp-head-callback'       => '',
		'admin-head-callback'    => '',
		'admin-preview-callback' => '',
	);
		
	global $wp_version;
		
	if ( version_compare( $wp_version, '3.4', '>=' ) ){ 
		add_theme_support( 'custom-background', $args );
		add_theme_support( 'custom-header', $defaults );
	}
	

	function maintenance_mode(){
	
		/* Yet to be Implement */
		
	}