<?php 
	
	/*	
	*	CrunchPress function.php
	*	---------------------------------------------------------------------
	* 	@version	1.0
	*   @ Package   WP Theme
	* 	@author		CrunchPress
	* 	@link		http://crunchpress.com
	* 	@copyright	Copyright (c) CrunchPress
	*	---------------------------------------------------------------------
	*	This file contains all important functions and features of the theme.
	*	---------------------------------------------------------------------
	*/	
	
	
	/************** Frequently Used Image Sizes In The Theme *************/
	
	add_image_size('wecare-features-thumbnail',265,200, true);			/* Features Thumbnail Image********(1) */	
	add_image_size('wecare-project-medium',282,282, true);				/* Current Projects Image**********(2) */
	add_image_size('wecare-post-thumbnail',340,320, true);				/* Testi Thumb ********************(3) */
	add_image_size('wecare-testi-thumbnail',83,83, true);				/* Testi Thumb ********************(4) */
	add_image_size('wecare-causes-listing',390,320, true);				/* Projects Listing****************(5) */
	add_image_size('wecare-causes-2col',555,380, true);					/* Projects Listing****************(6) */		
	add_image_size('wecare-events-thumbnail',360,300, true);			/* Testi Thumb ********************(7) */
	add_image_size('wecare-projects-thumbnail',585,350, true);			/* Testi Thumb ********************(8) */
	add_image_size('wecare-causes-full',650,450, true);					/* Blog Full***********************(9) */

	/************** Defined For the Theme  *************/
	
	if(!defined( 'wecare_PATH_URL' )){ define('wecare_PATH_URL', esc_url(get_template_directory_uri()));}  	 	/* logical location for CP framework */
	
	if(!defined( 'wecare_PATH_SER' )){define('wecare_PATH_SER', esc_url(get_template_directory()));}      	 	/* Physical location for CP framework */      
	
	if(!defined( 'wecare_FW_URL' )){define( 'wecare_FW_URL', esc_url(wecare_PATH_URL . '/framework' ));}  		/* Define URL path of framework directory */
	
	if(!defined( 'wecare_FW' )){define( 'wecare_FW', esc_url(wecare_PATH_SER . '/framework' ));}			 	/* Define server path of framework directory */

					
	/************** SSL Checks *************/

	if ( is_ssl() ) {
	
		define('HTTP', 'https://');
		
	}else{
	
		define('HTTP', 'http://');
		
	}
	
	/************** File Path If Needed For Child Theme  *************/
						
		if( !function_exists('wecare_get_root_directory') ){                      /* Get file path ( to support child theme ) */
			
			function wecare_get_root_directory( $path ){
			
				if( file_exists( get_stylesheet_directory() . '/' . $path ) ){
				
					return esc_url(get_stylesheet_directory() . '/');
					
				}else{
				
					return esc_url(get_stylesheet_directory() . '/');
				}
			}
		}

		add_filter( 'wpcf7_support_html5_fallback', '__return_true' ); 
	
					
	/************** include essential files to enhance framework functionality *************/
					
		include_once(wecare_FW.	'/script-handler.php');							/* It includes all javacript and style in theme */
		include_once(wecare_FW.	'/extensions/super-object.php'); 				/* Super object function */
		include_once(wecare_FW.	'/cp-functions.php'); 							/* Registered CP framework functions */
	
	/************** Theme and Framework Essential Files ************************************/ 
					
		include_once(wecare_FW.	'/cp-option.php');								/* CP framework control panel */
		include_once(wecare_FW.	'/wecare_options_typography.php');				/* CP Typography control panel */
		include_once(wecare_FW.	'/wecare_options_slider.php');					/* CP Slider control panel */
		include_once(wecare_FW.	'/wecare_options_social.php');					/* CP Social Sharing */
		include_once(wecare_FW.	'/wecare_options_sidebar.php');					/* CP Sidebar Option Page */
		include_once(wecare_FW.	'/wecare_options_default_pages.php');			/* CP Default Options control panel */
		include_once(wecare_FW.	'/wecare_dummy_data_import.php');				/* CP Dummy Data control panel */
	
		/* Backend or Dashboard Options */
		include_once(wecare_FW. '/options/meta-template.php'); 					/* templates for post portfolio and gallery */
		include_once(wecare_FW. '/options/post-option.php');					/* Register meta fields for post_type */
		include_once(wecare_FW. '/options/page-option.php'); 					/* Register meta fields page post_type */
		include_once(wecare_FW. '/options/product-option.php');					/* WooCommerce Elements */
	
	
	/************** Widgets Included In The Theme ************************/ 
	
		include_once(wecare_FW. '/extensions/widgets/wecare_contact_info.php'); 			/* Contact Info Widget */
		include_once(wecare_FW. '/extensions/widgets/wecare_events_widget.php'); 			/* Custom About Widget */
		include_once(wecare_FW. '/extensions/widgets/wecare_quick_links_widget.php'); 		/* Custom Quick Links Posts */
		include_once(wecare_FW. '/extensions/widgets/wecare_recent_posts_widget.php'); 		/* Custom Recent Posts Widget */
		include_once(wecare_FW. '/extensions/widgets/wecare_projects_widget.php'); 			/* Custom Projects Widget */
		

	/************** Plugins and Contact Files ************************/ 
	
		include_once(wecare_FW. '/extensions/plugins.php'); 								/* Custom Or External Plugins */
	
	/************** Essential Theme Files  **************************/ 
					
		if(!is_admin()){
			include_once(wecare_FW. '/extensions/sliders.php');	                            /* Functions to print sliders */
			include_once(wecare_FW. '/options/page-elements.php');	                        /* Organize page item element */
			include_once(wecare_FW. '/options/blog-elements.php');							/* Organize blog item element */
			include_once(wecare_FW. '/extensions/comment.php'); 							/* function to get list of comment */
			include_once(wecare_FW. '/extensions/pagination.php'); 							/* Register pagination plugin */
			include_once(wecare_FW. '/extensions/social-shares.php'); 						/* Register social shares  */
			include_once(wecare_FW. '/extensions/loadstyle.php');                  			/* Register breadcrumbs navigation */
			include_once(wecare_FW. '/extensions/breadcrumbs.php');                 		/* Register breadcrumbs navigation */
			include_once(wecare_FW. '/extensions/featured-content.php');                	/* Register Feature content */
			include_once(wecare_FW. '/extensions/cp-headers.php'); 							/* Registered CP Header style */
			include_once(wecare_FW. '/extensions/cp-footers.php'); 							/* Registered CP Header style */
		}
				
	/************** Fetch Values From Theme Panel  **************************/ 

		function wecare_get_themeoption_value($para_val='',$get_option=''){
		
			/* Fetch Data From Theme Options */
			$wecare_general_settings = get_option($get_option);
			
			if($wecare_general_settings <> ''){
			
				$wecare_logo = new DOMDocument ();
				
				$wecare_logo->loadXML ( $wecare_general_settings );
				
				return wecare_find_xml_value($wecare_logo->documentElement,$para_val);
				
			}else{
			
				return $para_val;
			}
		
		}
		
		
		/* 
	
			* ThemeForest Recommendation
			
			* "after_setup_theme" hook added
			
			* Calling required files/functions through setup function
			
			* Intialize Custom Functions On Theme Setup
	
		
		*/
		
		
		add_action( 'after_setup_theme', 'wecare_theme_setup' );

		function wecare_theme_setup() {

			/* Decalare WooCommerce Support */
			add_theme_support( 'woocommerce' );
			
			add_action('woocommerce_before_main_content', 'wecare_wrapper_start', 10);
		
			add_action('woocommerce_after_main_content', 'wecare_wrapper_end', 10);
		
			add_action('woocommerce_before_main_content', 'wecare_woocommerce_remove_breadcrumb');
		
			add_action( 'woo_custom_breadcrumb', 'wecare_woocommerce_custom_breadcrumb' );	

			
			/* Theme Customize Class Hooks */
		
			add_action( 'customize_register' , array( 'wecare_Customize' , 'wecare_register' ) );
			
			add_action( 'wp_head' , array( 'wecare_Customize' , 'wecare_header_output' ) );
			
			add_action( 'customize_preview_init' , array( 'wecare_Customize' , 'wecare_live_preview' ) );


			/* Audio Player Hook */
			if ( ! has_action( 'audio_player', 'wp_print_styles' ) )
			add_action( 'audio_player', 'wp_print_styles', 11 );
			
			
			/* Register your custom function to override some LayerSlider data */
			add_action('layerslider_ready', 'wecare_my_layerslider_overrides');
			
			
			
			/* Theme Dummy Installation */
			add_action('wp_ajax_wecare_themeple_ajax_dummy_data', 'wecare_themeple_ajax_dummy_data');
			
			
			/* Dummy Importer */
			add_action('wp_ajax_cp_dummy_import', 'wecare_dummy_import');
			
			
			/* Dequeue LayerSlider Fonts */
			add_action( 'wp_enqueue_scripts', 'wecare_wpse_dequeue_google_fonts', 10 );
			
		}

		/**************  Declare WooCommerce Support  **************************/ 
				

		function wecare_wrapper_start() {

			$select_layout_jobinn = '';	
			$wecare_general_settings = get_option('general_settings');
			
			if($wecare_general_settings <> ''){
				$wecare_logo = new DOMDocument ();
				$wecare_logo->loadXML ( $wecare_general_settings );
				$select_layout_jobinn = wecare_find_xml_value($wecare_logo->documentElement,'select_layout_cp');
				
			}
			
			$wecare_breadcrumbs = wecare_get_themeoption_value('breadcrumbs','general_settings');
			
			$wecare_header_style = '';
			$wecare_html_class = wecare_print_header_class($wecare_header_style);
		?>
		
		<div id="inner-banner">
			<div class="container">
				<h1><?php if(is_single()){ echo esc_attr(get_the_title());}else{ woocommerce_page_title();};?></h1>
				<em><?php esc_html_e('WooCommerce Shop','wecare');?></em>
				<?php /* Breadcrumb Only */
					$wecare_breadcrumbs = '';
					$wecare_breadcrumbs = wecare_get_themeoption_value('breadcrumbs','general_settings');
					
					if($wecare_breadcrumbs == 'enable'){

						echo do_action('woo_custom_breadcrumb');

					} /* breadcrumbs ends */ 
				?>
			</div>
		</div>
		
		<section class="container" id="main-woo"><div class = "product-page">	
		<?php }
		  
		function wecare_wrapper_end() {
			
			echo '</div></section>';
		}
	
		/*  Reposition WooCommerce breadcrumb */
		function wecare_woocommerce_remove_breadcrumb(){
			remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
		}

		/*  Custom WooCommerce breadcrumb */
		function wecare_woocommerce_custom_breadcrumb(){
			woocommerce_breadcrumb();
		}

		/* Theme Dummy Installation Function */
		function wecare_themeple_ajax_dummy_data(){
			require_once wecare_FW . '/extensions/importer/dummy_data.inc.php';
			die(esc_html__('themeple_dummy','wecare'));
		}
	
	
		/* Theme Dummy Data Installation */
		function wecare_dummy_import(){
			foreach ($_REQUEST as $keys=>$values) {
				$$keys = trim($values);
			}
			$wecare_layout = $layout;
			if(wp_verify_nonce( $wecare_nonce_dummy, 'wecare_nonce_dummy' )){
				require_once wecare_FW . '/extensions/importer/dummy_data.inc.php';
				die(esc_html__('dummy_import','wecare'));
			}else{
				die(esc_html__('Not Loaded','wecare'));
			}
		}
	
	/**
	 * Contains methods for customizing the theme customization screen.
	 */
	class wecare_Customize {
	   
	   public static function wecare_register ( $wp_customize ) {
		  //1. Define a new section (if desired) to the Theme Customizer
		  $wp_customize->add_section( 'wecare', 
			 array(
				'title' => esc_html__( 'We Care Options', 'wecare' ), //Visible title of section
				'priority' => 35, //Determines what order this appears in
				'capability' => 'edit_theme_options', //Capability needed to tweak
				'description' => esc_html__('Allows you to customize some example settings for crunchpress.', 'wecare'), //Descriptive tooltip
			 ) 
		  );
		  
		  //2. Register new settings to the WP database...
		  $wp_customize->add_setting( 'wecare_options[link_textcolor]', //Give it a SERIALIZED name (so all theme settings can live under one db record)
			 array(
				'default' => '#ffffff', //Default setting/value to save
				'type' => 'option', //Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
				'sanitize_callback' => 'sanitize_hex_color'
			 ) 
		  );      
				
		  //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
		  $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
			 $wp_customize, //Pass the $wp_customize object (required)
			 'wecare_link_textcolor', //Set a unique ID for the control
			 array(
				'label' => esc_html__( 'Link Color & Button Color', 'wecare' ), //Admin-visible name of the control
				'section' => 'colors', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'wecare[link_textcolor]', //Which setting to load and manipulate (serialized is okay)
				'priority' => 10, //Determines the order this control appears in for the specified section
			 ) 
		  ) );
		  
		  
		  //4. We can also change built-in settings by modifying properties. For instance, let's make some stuff use live preview JS...
		  $wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
		  $wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
		  $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
		  $wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
	   }

	   /**
		* This will output the custom WordPress settings to the live theme's WP head.
		*/
	   public static function wecare_header_output() {
		  ?>
		  <!--Customizer CSS--> 
		  <style type="text/css">
			   <?php self::wecare_generate_css('#site-title a', 'color', 'header_textcolor', '#'); ?> 
			   <?php self::wecare_generate_css('body', 'background-color', 'background_color', '#'); ?> 
			   <?php self::wecare_generate_css('a', 'color', 'wecare[link_textcolor]'); ?>
		  </style> 
		  <!--/Customizer CSS-->
		  <?php
	   }
	   
	   /**
		* This outputs the javascript needed to automate the live settings preview.
		* Also keep in mind that this function isn't necessary unless your settings 
		* are using 'transport'=>'postMessage' instead of the default 'transport'
		*/
	   public static function wecare_live_preview() {
		  wp_enqueue_script( 
			   'wecare-themecustomizer', // Give the script a unique ID
			   esc_url(get_template_directory_uri() . '/frontend/js/theme-customizer.js'), // Define the path to the JS file
			   array(  'jquery', 'customize-preview' ), // Define dependencies
			   '', // Define a version (optional) 
			   true // Specify whether to put in footer (leave this true)
		  );
	   }

		/**
		 * This will generate a line of CSS for use in header output. If the setting
		 * ($mod_name) has no defined value, the CSS will not be output.
		 */
		public static function wecare_generate_css( $selector, $style, $mod_name, $prefix='', $postfix='', $echo=true ) {
		  $wecare_return = '';
		  $wecare_mod = get_theme_mod($mod_name);
		  if ( ! empty( $wecare_mod ) ) {
			 $wecare_return = sprintf('%s { %s:%s; }',
				$selector,
				$style,
				$prefix.$wecare_mod.$postfix
			 );
			 if ( $echo ) {
				echo esc_attr($wecare_return);
			 }
		  }
		  return $wecare_return;
		}
	}

	function wecare_my_layerslider_overrides() {
 
        /* Disable auto-updates for LayerSlider */
        $GLOBALS['lsAutoUpdateBox'] = false;
    
	}
	
	
	/* Admin Dashboard Notice HTML */
	function wecare_admin_notice_framework() { ?>
		
		<div class="updated">
			<p><strong><?php esc_html_e( 'Please install theme required plug-ins to use all functionalities of theme', 'wecare' ); ?></strong> - <?php esc_html_e('in case of deactivating the theme required plug-ins you may not able to use theme extra functionality.','wecare');?></p>
		</div>
		
		<?php
	}

	/* DeQueue LayerSlider Fonts */
	function wecare_wpse_dequeue_google_fonts() {
		
		wp_dequeue_style( 'ls-google-fonts' );

	}
	
	/* Avoiding Index.php Issue */
	function wecare_get_featured_posts() {
		
		return apply_filters( 'wecare_get_featured_posts', array() );
	
	}