<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_features_grid")){
	class wecare_features_grid{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_features_grid_init"));
			add_shortcode('wecare_features_grid',array($this,'wecare_features_grid_shortcode'));
		}
		function wecare_features_grid_init(){

			if(function_exists("vc_map")){
			
				/* Features Cat */
				$args = array(
					'type'                     => 'features',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'features-categories',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 				

				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
				
				
	
				vc_map( array(
					"base" => "wecare_features_grid",
					"name" => __( "Features Grid", "js_composer" ),
					"class" => "wecare_features_grid_class",
					"icon" => "wecare_features_grid",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
							array(
								"type" => "dropdown",
								"heading" => __( "Element Style", "js_composer" ),
								"param_name" => "element_style",
								"value" =>  array( __( 'Style 1', 'js_composer' ) => 'style_1',
													__( 'Style 2', 'js_composer' ) => 'style_2',
														
													),
								"description" => __( "Select Element Style", "js_composer" )
							),

							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Sub Title", "js_composer" ),
								"param_name" => "element_subtitle",
								"description" => __( "Enter Element Sub Title", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here", "js_composer" )
							),
							

							array(
								"type" => "dropdown",
								"holder" => "p",
								"heading" => __( "Category Features", "js_composer" ),
								"param_name" => "category_name",
								"value" => $categoryArray,
								"description" => __( "Select Category From The Dropdown", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Number of Posts", "js_composer" ),
								"param_name" => "num_posts",
								"description" => __( "Enter Number of Features To Display", "js_composer" )
							),	
							
						)
					) 
				);
			}
		}
		
		
		function wecare_features_grid_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
			
				'element_subtitle' => '',
				'element_title' => '',
				'category_name' => '',
				'num_posts' => '4',	
				'element_style' => 'style_1',
				
			), $atts );

			extract( $result );
			
			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'features-categories');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'features-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' => 'features',
						'posts_per_page' => $num_posts,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'features-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'features',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> $num_posts,
						'orderby'		 	=> 'date',
						'order' 			=> 'ASC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'features',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> $num_posts,
					'orderby'		 	=> 'date',
					'order' 			=> 'ASC'
				);
			
			}

			query_posts($args);	
			
			if($element_style == 'style_1'){
			
			/* HTML Markup */
				
				$output = '
				
					<section class="featured-services">
					  <div class="element_wrap">
						<div class="heading-style-1 line"> 
							<span>'.$element_subtitle.'</span>
							<h2>'.$element_title.'</h2>
						</div>
						<div class="row">';
						  
							/* Loop Begins */
								if ( have_posts() ) {
								 
									while ( have_posts() ) { the_post(); global $post;
									
									$wecare_features_detail_xml = get_post_meta($post->ID, 'wecare_features_detail_xml', true);
									
									$features_caption = '';
									
									if($wecare_features_detail_xml <> ''){
									
										$features_xml = new DOMDocument ();
										
										$features_xml->loadXML ( $wecare_features_detail_xml );
										
										$features_caption = wecare_find_xml_value($features_xml->documentElement,'features_caption');	
									}
									
									$output .='
									
									<div class="col-md-3 col-sm-6">
										<div class="featured-box">
										  <div class="frame">'.get_the_post_thumbnail($post->ID, array(265,200)).'</div>
										  <div class="text-box"> 
											<span>'.esc_attr($features_caption).'</span>
											<h4>'.get_the_title().'</h4>
										  </div>
										</div>
									</div>';
  
									} /* endwhile */ wp_reset_query();
								} /*endif*/
								$output .='
						</div>
					 </div>
					</section>';
			}
			
			if($element_style == 'style_2'){
			
				/* HTML Markup */
				
				$output = '
				
					<section class="featured-services-style-2">
						<div class="container">
						  <div class="heading-style-1"> 
								<span>'.$element_subtitle.'</span>
								<h2>'.$element_title.'</h2>
						  </div>
						  <div class="row">';
							/* Loop Begins */
								if ( have_posts() ) {
								 
									while ( have_posts() ) { the_post(); global $post;
									$content = get_the_content();
									$feature_content = wp_trim_words( $content, 7, '' );
									
										static $features_counter = 1;
										
										/* Long Section */
										if($features_counter == 1 || $features_counter == 6){
											
											$output .= '
											
											<div class="col-md-3 col-sm-3">
												<div class="box">
													<div class="holder"> '.get_the_post_thumbnail($post->ID, 'full').'
													  <h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
													  <p>'.$feature_content.'</p>
													</div>
												</div>
											</div>';
										
										}else{
										/* Short Section */
											
											if($features_counter % 2 == 0){ $output .= '<div class="col-md-3 col-sm-3">'; }
												
												$output .= '
													<div class="box"> '.get_the_post_thumbnail($post->ID, 'full').'
														<h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
														<p>'.$feature_content.'</p>
													</div>';
											
											if($features_counter % 2 == 1){ $output .= ' </div>'; }
											
										}
										
										$features_counter++;
									} /* endwhile */ wp_reset_query();
								}
							$output .= '
						  </div>
						</div>
					</section>';	
			}

			return $output;

			wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_features_grid;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_features_grid extends WPBakeryShortCode {
		}
	}
}