<?php

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'clsop_is_apache2nginx' ) ) {
	/**
	 * Detect it is apache2nginx web server
	 *
	 * @note CL.
	 * @return bool
	 */
	function clsop_is_apache2nginx() {
		$result = false;
		if (
			isset( $_SERVER['SERVER_SOFTWARE_EXTRA'] )
			&&
			strpos( $_SERVER['SERVER_SOFTWARE_EXTRA'], 'CloudLinux MAx Webserver' ) !== false // phpcs:ignore WordPress.Security.ValidatedSanitizedInput
		) {
			$result = true;
		}

		return apply_filters( 'rocket_clsop_is_apache2nginx', $result );
	}
}

if ( ! function_exists( 'clsop_is_litespeed' ) ) {
	/**
	 * Detect it is LiteSpeed web server
	 *
	 * @note CL.
	 * @return bool
	 */
	function clsop_is_litespeed() {
		$result = false;
		if (
			isset( $_SERVER['SERVER_SOFTWARE'] )
			&&
			strpos( $_SERVER['SERVER_SOFTWARE'], 'LiteSpeed' ) !== false // phpcs:ignore WordPress.Security.ValidatedSanitizedInput
		) {
			$result = true;
		}

		return apply_filters( 'rocket_clsop_is_litespeed', $result );
	}
}

if ( ! function_exists( 'clsop_is_wp2_environment' ) ) {
	/**
	 * Detect if it's a WP2 environment (checks wp-config constant only).
	 *
	 * @return bool
	 */
	function clsop_is_wp2_environment() {
		// Check wp-config constant (handles boolean true or string 'true').
		if ( defined( 'IS_WP2_ENVIRONMENT' ) && filter_var( IS_WP2_ENVIRONMENT, FILTER_VALIDATE_BOOLEAN ) ) {
			return true;
		}

		// Default to false if no constant or false/'false'.
		return false;
	}
}
