<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_gallery_layouts")){
	class wecare_gallery_layouts{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_gallery_layouts_init"));
			add_shortcode('wecare_gallery_layouts',array($this,'wecare_gallery_layouts_shortcode'));
		}
		function wecare_gallery_layouts_init(){

			if(function_exists("vc_map")){
			
				/* Fetch Hotspot Posts */
				$gallery_title = array();
				
				$galleries = get_posts(array('post_type' => 'gallery', 'numberposts'=>100));
				
				if(is_array($galleries)){
					foreach ($galleries as $gallery) {
						$gallery_title[$gallery->ID] = $gallery->ID;
					}
				}else{
					$gallery_title = array();
				}
				
				vc_map( array(
					"base" => "wecare_gallery_layouts",
					"name" => __( "Gallery Layouts", "js_composer" ),
					"class" => "wecare_gallery_layouts_class",
					"icon" => "wecare_gallery_layouts_icon",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
						array(
								"type" => "dropdown",
								"holder" => "p",
								"heading" => __( "Select Gallery", "js_composer" ),
								"param_name" => "category_name",
								"value" => $gallery_title,
								"description" => __( "Select Gallery From The Dropdown", "js_composer" )
						),
						
						array(
							'type' => 'dropdown',
							"holder" => "p",
							'heading' => __( 'Select Gallery Layout Style', 'js_composer' ),
							'param_name' => 'select_style',
							'value' =>  array( __( 'Full', 'js_composer' ) => 'full',
												__( 'Large', 'js_composer' ) => 'large',
												__( 'Medium', 'js_composer' ) => 'medium',
												__( 'Small', 'js_composer' ) => 'small',
												
												),
							'description' => __( 'Select Gallery Style From Given Options', 'js_composer' ),
						),
						
						array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Image Count", "js_composer" ),
								"param_name" => "img_count",
								"description" => __( "Enter Images To Display On First Page", "js_composer" )
						),

					)
				) );
			}
		}
		
		
		function wecare_gallery_layouts_shortcode( $atts, $content = null ) {
			
			$result = shortcode_atts( array(
				
				'category_name' => '',
				'select_style' => 'full',
				'img_count' => '8',

			), $atts );
			
			
			extract( $result );
			
			/* Pretty Photo Scripts */
			wp_enqueue_style('prettyPhoto',wecare_PATH_URL.'/frontend/css/prettyphoto.min.css');
		
			wp_enqueue_script( 'prettyPhoto', wecare_PATH_URL.'/frontend/js/jquery.prettyphoto.min.js', false, '1.0', true);
			
			
			/*** Full Gallery ***/
			if($select_style == 'full'){
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							<section class="gallery-section">
							  <div class="element_wrap">
								<div class=" row gallery">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, 'full');
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
	
												$output .= '
													
													<div class="col-md-12 col-sm-6">
														<div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="img">
														  <div class="caption">
															<div class="inner">
															  <div class="btn-row"> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																<a href="'.esc_url($wecare_image_url[0]).'" data-rel="prettyPhoto[gallery1]" class="link"><i class="fa fa-link" aria-hidden="true"></i></a> 
															   </div>
															</div>
														  </div>
														</div>
													</div>';
													
											} /* end forloop */
										
						} /* endif */
						
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4);
								
					} /* endif */
					
						$output .= '
					</div>
				  </div>
				</section>';
			
				return $output;
			
			} /* endif style 1 */
			
			
			/*** Large ***/
			if($select_style == 'large'){
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							 <section class="gallery-section">
							  <div class="element_wrap">
								<div class=" row gallery">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, array(585,350));
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
													$output .= '
													
													<div class="col-md-6">
														<div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="'.esc_html__('gallery image','theneeds').'">
														  <div class="caption">
															<div class="inner">
															  <div class="btn-row"> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																<a href="'.esc_url($wecare_image_url[0]).'" data-rel="prettyPhoto[gallery1]" class="link"><i class="fa fa-link" aria-hidden="true"></i></a> 
															  </div>
															</div>
														  </div>
														</div>
													</div>';
		  
											} /* end forloop */
										
						} /* endif */
					
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4);
				
												
					} /* endif */
					
						$output .= '
					</div>
				  </div>
				</section>';
			
				return $output;
			
			} /* endif style 2 */
			
			/*** Medium Layouts ***/
			if($select_style == 'medium'){
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							<section class="gallery-section">
							  <div class="element_wrap">
								<div class=" row gallery">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, array(555,380));
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
												$output .= '
												
													<div class="col-md-4">
														<div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="'.esc_html__('gallery image','theneeds').'">
														  <div class="caption">
															<div class="inner">
															  <div class="btn-row"> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																<a href="'.esc_url($wecare_image_url[0]).'" data-rel="prettyPhoto[gallery1]" class="link"><i class="fa fa-link" aria-hidden="true"></i></a> </div>
															</div>
														  </div>
														</div>
													</div>';

											} /* end forloop */
										
						} /* endif */
					
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4);
				
												
					} /* endif */
					
						$output .= '
					</div>
				</div>
			</section>';
			
				return $output;
			
			} /* endif style 3 */
			
			/*** Small Layout ***/
			if($select_style == 'small'){
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							 <section class="gallery-section">
							  <div class="element_wrap">
								<div class=" row gallery">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, array(282,282));
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
												
													
													$output .= '
													
														<div class="col-md-3">
															<div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="'.esc_html__('gallery image','theneeds').'">
															  <div class="caption">
																<div class="inner">
																  <div class="btn-row"> 
																	<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																	<a href="'.esc_url($wecare_image_url[0]).'" data-rel="prettyPhoto[gallery1]" class="link"><i class="fa fa-link" aria-hidden="true"></i></a> </div>
																</div>
															  </div>
															</div>
														</div>';
													
		
											} /* end forloop */
										
						} /* endif */
					
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4);
				
												
					} /* endif */
					
						$output .= '
					</div>
				  </div>
			 </section>';
			
				return $output;
			
			} /* endif style 4 */
			
			/*** 4 Column Layout ***/
			if($select_style == '4_col'){
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							 <section class="portfolio-style-1 padd-none gallery-large gallery-4-col">
								
								<div class="container">
									
									<div class="gallery padd-btm-90">
										
										<div class="row">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, 'full');
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
												
													
													$output .= '
													
													<div class="col-md-3 col-sm-6">
													  <div class="outer">
														<div class="thumb"> <img src="'.esc_url($wecare_image_url[0]).'" alt="img">
														  <div class="caption">
															<div class="inner">
															  <div class="btn-row"> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link"><i class="fa fa-link" aria-hidden="true"></i></a> 
															</div>
															  <h3><a href="'.esc_url($wecare_image_url[0]).'">'.esc_attr($wecare_title).'</a></h3>
															  <span>'.esc_attr($wecare_caption).'</span> </div>
														  </div>
														</div>
													  </div>
													</div>';
					
											} /* end forloop */
										
						} /* endif */
					
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4);
				
												
					} /* endif */
					
						$output .= '
					</div>
				  </div>
				</div>
			 </section>';
			
			return $output;
			
			} /* endif style 4 */
			
			
			/*** 4 Column Layout ***/
			if($select_style == 'classic'){
			
				wp_enqueue_script( 'cp-isotope', wecare_PATH_URL.'/frontend/js/isotope.pkgd.min.js', false, '1.0', true);
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							<section class="cp-gallery gallery-section gallery">
							  <div class="element_wrap">
								<div class="row">
								  <div class="cp-gallery-metro-2 gallery-grid gallery">
									<ul class="cp-grid isotope items">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, 'full');
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
													static $image_counter_classic = 1;
													
													if($image_counter_classic % 6 == 1){
													
														$li_class = "width2 height2 col-md-8";
													
													}else{
													
														$li_class = "col-md-4";
													}
													
													$output .= '
													
													<li class="item '.$li_class.'">
														<div class="cp-box">
														  <div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="'.esc_html__('img','theneeds').'">
															<div class="caption">
															  <div class="holder"> 
																<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
																<a data-rel="prettyPhoto[gallery1]" href="'.esc_url($wecare_image_url[0]).'" class="link"><i class="fa fa-link" aria-hidden="true"></i></a>
																<h3><a data-rel="prettyPhoto[gallery1]" href="'.esc_url($wecare_image_url[0]).'">'.esc_attr($wecare_caption).'</a></h3>
															  </div>
															</div>
														  </div>
														</div>
													</li>';
													
													$image_counter_classic++;
													
													
				
											} /* end forloop */
										
						} /* endif */
					
												
					} /* endif */
					
						$output .= '
					</ul>
				  </div>
				</div>';
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4).'
				</div>
			 </section>';
			
			return $output;
			
			} /* endif style 4 */
			
			/*** 4 Column Layout ***/
			if($select_style == 'elite'){
			
				wp_enqueue_script( 'cp-isotope-main', wecare_PATH_URL.'/frontend/js/jquery.isotope.js', false, '1.0', true);
			
				wp_enqueue_script( 'cp-isotope', wecare_PATH_URL.'/frontend/js/isotope.pkgd.min.js', false, '1.0', true);
			
				global $wecare_gallery_layouts_div_size_listing_class;
				
				global $paged,$sidebar,$post_id,$wp_query;	

				$output = '';

				if(empty($paged)){
					
					$wecare_paged = (get_query_var('page')) ? get_query_var('page') : 1; 
				}
			
				$wecare_gal_counter = 3;
				$wecare_gallery_layouts_size = 'Catalogue View';
				$wecare_gallery_layouts_size = '';
				$wecare_num_size = $img_count;
				$wecare_gallery_layouts_class = '';

				/* Gallery XML */
				$wecare_slider_xml_string = get_post_meta($category_name,'post-option-gallery-xml', true);
				
				if($wecare_slider_xml_string <> ''){
					
					$wecare_slider_xml_dom = new DOMDocument();
						
						if( !empty( $wecare_slider_xml_string ) ){
							
							$wecare_slider_xml_dom->loadXML($wecare_slider_xml_string);
							
							$output .= '
							
							<section class="cp-gallery gallery-section gallery">
							  <div class="container-fluid">
								<div class="cp-gallery-metro-1 gallery-grid gallery">
								  <ul class="cp-grid isotope items">';
								
										$wecare_children = $wecare_slider_xml_dom->documentElement->childNodes;
							
										if ( empty($wp_query->query['paged']) ) $wp_query->query['paged'] = 1;
								
											$wecare_total_page = '';
											
											if($wecare_num_size > 0){
												
												$wecare_limit_start = $wecare_num_size * ($wp_query->query['paged']-1);
												
												$wecare_limit_end = $wecare_limit_start + $wecare_num_size;
												
												if ( $wecare_limit_end > $wecare_slider_xml_dom->documentElement->childNodes->length ) {
	
													$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
												}
												
												if($wecare_num_size < $wecare_slider_xml_dom->documentElement->childNodes->length){
													
													$wecare_total_page = ceil($wecare_slider_xml_dom->documentElement->childNodes->length/$wecare_num_size);
													
												}else{
													
													$wecare_total_page = 1;
												}
											
											}else {
										
												$wecare_limit_start = 0;
												
												$wecare_limit_end = $wecare_slider_xml_dom->documentElement->childNodes->length;
											
											}
											
											$wecare_counter_gal_element = 0;
											
											$wecare_single_col = 0;
								
											for($i=$wecare_limit_start;$i<$wecare_limit_end;$i++) { 
												
												$wecare_thumbnail_id = wecare_find_xml_value($wecare_children->item($i), 'image');
												$wecare_title = wecare_find_xml_value($wecare_children->item($i), 'title');
												$wecare_caption = wecare_find_xml_value($wecare_children->item($i), 'caption');
												$wecare_link_type = wecare_find_xml_value($wecare_children->item($i), 'linktype');
												$wecare_video = wecare_find_xml_value($wecare_children->item($i), 'video');
												
												$wecare_image_url = wp_get_attachment_image_src($wecare_thumbnail_id, 'full');
												$wecare_alt_text = get_post_meta($wecare_thumbnail_id , '_wp_attachment_image_alt', true);	
												
													static $image_counter_classic = 1;
													
													if($image_counter_classic == 3  || $image_counter_classic == 7 || $image_counter_classic == 9 || $image_counter_classic == 12){
													
														$li_class = "width2";
													
													}elseif($image_counter_classic == 2 || $image_counter_classic == 10){
													
														$li_class = "height2";
													
													}else{
													
														$li_class  = "";
													}
													
													$output .= '
													
													<li class="item '.$li_class.'">
													  <div class="cp-box">
														<div class="frame"> <img src="'.esc_url($wecare_image_url[0]).'" alt="'.esc_html__('img','theneeds').'">
														  <div class="caption">
															<div class="holder">
															<a href="'.esc_url($wecare_image_url[0]).'" class="link" data-rel="prettyPhoto[gallery1]"><i class="fa fa-plus" aria-hidden="true"></i></a> 
															<a data-rel="prettyPhoto[gallery1]" href="'.esc_url($wecare_image_url[0]).'" class="link"><i class="fa fa-link" aria-hidden="true"></i></a>
															  <h3><a data-rel="prettyPhoto[gallery1]" href="'.esc_url($wecare_image_url[0]).'">'.esc_attr($wecare_caption).'</a></h3>
															</div>
														  </div>
														</div>
													  </div>
													</li>';
													
												
													
													$image_counter_classic++;
													
													
				
											} /* end forloop */
										
						} /* endif */
					
												
					} /* endif */
					
						$output .= '
					</ul>
				  </div>
				</div>';
						/***** Pagination ****/
						$output .= pagination_crunch($pg_style = '',$style = '', $wecare_total_page, $range = 4).'
			 </section>';
			
			return $output;
			
			} /* endif style 4 */
			
			
		}
		
	}
	new wecare_gallery_layouts;
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_gallery_layouts extends WPBakeryShortCode {
		}
	}
}