<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_campaign_columns")){
	class wecare_campaign_columns{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_campaign_columns_init"));
			add_shortcode('wecare_campaign_columns',array($this,'wecare_campaign_columns_shortcode'));
		}
		function wecare_campaign_columns_init(){

			if(function_exists("vc_map")){
				
				 $args = array(
					'type'                     => 'campaign',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'campaign_category',
					'pad_counts'               => false 
				);
				
				
				$categories = get_categories( $args ); 				
						
				
				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
				
				vc_map( array(
					"base" => "wecare_campaign_columns",
					"name" => __( "Campaign Columns", "js_composer" ),
					"class" => "wecare_campaign_columns_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_campaign_columns_news_full",
					"params" => array(
					
						
		
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Campaign Count", "js_composer" ),
							"param_name" => "num_posts",
							"description" => __( "Enter Number of Campaign to Fetch", "js_composer" )
						),
						
						array(
							"type" => "dropdown",
							"holder" => "p",
							"heading" => __( "Categories", "js_composer" ),
							"param_name" => "category_name",
							"value" => $categoryArray,
							"description" => __( "Select Category From The Dropdown", "js_composer" )
						),
						
						array(
							'type' => 'checkbox',
							"holder" => "p",
							'heading' => __( 'Display Pagination', 'js_composer' ),
							'param_name' => 'display_pagination',
							'value' => array( __( 'Yes, Please', 'js_composer' ) => 'yes' ),
							'description' => __( 'Display Pagination At The End of Section', 'js_composer' ),
						),
					)
				) );
			}
		}
		
		
		function wecare_campaign_columns_shortcode( $atts, $content = null ) {
			
			$result = shortcode_atts( array(

				'num_posts' => '6',
				'category_name' => '',
				'display_pagination' => '',

			), $atts );
			
			extract( $result );

			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'campaign_category');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'campaign_category',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' => 'campaign',
						'posts_per_page' => $num_posts,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'campaign_category',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'DESC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'campaign',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> $num_posts,
						'orderby'		 	=> 'date',
						'order' 			=> 'DESC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'campaign',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> $num_posts,
					'orderby'		 	=> 'date',
					'order' 			=> 'DESC'
				);
			
			}
			
			
			query_posts($args);
			
			
			$output = '';
			
			$output = '
			
				<section class="causes-section causes-2-col">
				  <div class="element_wrap">
					<div class="row">';
				
					/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;
								
								/* Get Campaign Object */
								$campaign = charitable_get_current_campaign();
								
								/* Percentage Donated */
								$percentage_donated_raw = intval($campaign->get_percent_donated_raw());
								
								/* Days Left */
								$campaign_days_left = $campaign->get_time_left();
								
								/* Get Donor Count */
								$campaign_donor_count = $campaign->get_donor_count();
								
								/* Get Currency Symbol */
								//$currency_symbol = Charitable_Currency::get_currency_symbol();
								
								/* Initialize Variables */
								$donated_amount = $goal_amount = $needed_amount = '';
								
								/* Campaign Goal */
								$goal_amount = $campaign->sanitize_campaign_goal( $campaign->get( 'goal' ) );
								
								/* Donated Amount */
								$donated_amount = intval($campaign->get_donated_amount());
								
								/* Amount Left */
								$needed_amount = $goal_amount - $donated_amount;

								$output .= '
								
									<div class="col-md-6 col-sm-6">
										<div class="causes-box">
										  <div class="frame"><a href="'.esc_url(get_the_permalink()).'">'.get_the_post_thumbnail($post->ID, array(555,380)).'</a></div>
										  <div class="text-box">
											<h3><a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a></h3>
											<div class="progress">
											  <div class="progress-bar" role="progressbar" aria-valuenow="'.esc_attr($percentage_donated_raw).'" aria-valuemin="0" aria-valuemax="100" style="width: '.esc_attr($percentage_donated_raw).'%;"> <span class="sr-only">'.esc_attr($percentage_donated_raw).'% '.esc_html__('Complete','wecare').'</span> </div>
											</div>
											<ul class="donors">
											  <li> <span class="title">'.esc_html__('Need','wecare').'</span> <strong class="amount">'.charitable_format_money($goal_amount).'</strong> </li>
											  <li> <span class="title">'.esc_html__('Donors','wecare').'</span> <strong class="amount">'.esc_attr($campaign_donor_count).'</strong> </li>
											  <li> <span class="title">'.esc_html__('Raised','wecare').'</span> <strong class="amount">'.charitable_format_money($donated_amount).'</strong> </li>
											</ul>
										  </div>
										  <div class="btm-row">
											<a href="'.esc_url(charitable_get_permalink( 'campaign_donation_page', array( 'campaign' => $campaign ) )).'" class="btn-now"><i class="fa fa-calendar" aria-hidden="true"></i>'.html_entity_decode($campaign_days_left).'</a>
											<a href="'.esc_url(charitable_get_permalink( 'campaign_donation_page', array( 'campaign' => $campaign ) )).'" class="btn-now btn-color">'.esc_html__('Contribute Now','wecare').'</a>
										  </div>
										</div>
									</div>';
		  
							} /* endwhile */
							
							if($display_pagination == 'yes'){
								
								$output .= '
									<div class="pagination-col">
										<nav>
											<ul class="pagination">
												<li>'.
													wecare_pagination().'
												</li>
											</ul>
										</nav>
									</div>';
							}
							
							
						} 	wp_reset_query(); /* endif have post */
						
						$output .= '
				  </div>
				 </div>
				</section>';

			
			return $output;
				
			wp_reset_postdata();
					

		} /* OutPut Function Ends Here */
		
		
	} /* class ends here */
	
	new wecare_campaign_columns;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_campaign_columns extends WPBakeryShortCode {
		}
	}
}