<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_testimonials_slider")){
	class wecare_testimonials_slider{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_testimonials_slider_init"));
			add_shortcode('wecare_testimonials_slider',array($this,'wecare_testimonials_slider_shortcode'));
		}
		function wecare_testimonials_slider_init(){

			if(function_exists("vc_map")){
				
				 $args = array(
					'type'                     => 'testimonial',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'testimonial-category',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 				

				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
	
				vc_map( array(
					"base" => "wecare_testimonials_slider",
					"name" => __( "Testimonials Slider", "js_composer" ),
					"class" => "wecare_testimonials_slider_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_testimonials_slider_icon",
					"params" => array(
					
						array(
								"type" => "dropdown",
								"heading" => __( "Element Style", "js_composer" ),
								"param_name" => "testi_styles",
								"value" =>  array( 	__( 'Horizontal Slides', 'js_composer' ) => 'horizontal',
													__( 'Dual Slides', 'js_composer' ) => 'dual',
												),
								"description" => __( "Select Element Style", "js_composer" )
							),

						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Enter Element Title", "js_composer" ),
							"param_name" => "element_title",
							"description" => __( "Enter Element Title To Display", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Enter Element Caption", "js_composer" ),
							"param_name" => "element_caption",
							"description" => __( "Enter Element Caption To Display", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Number Of Testimonials", "js_composer" ),
							"param_name" => "num_posts",
							"description" => __( "Enter Number Of Testimonials To Display", "js_composer" )
						),
							
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Excerpt Length", "js_composer" ),
							"param_name" => "num_characters",
							"description" => __( "Enter Number of Excerpt Length", "js_composer" )
						),
						
						array(
							"type" => "dropdown",
							"holder" => "p",
							"heading" => __( "Categories", "js_composer" ),
							"param_name" => "category_name",
							"value" => $categoryArray,
							"description" => __( "Select Category To Fetch Testimonials From", "js_composer" )
						),
	
					)
				) );
			}
		}
		
		
		function wecare_testimonials_slider_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(

				'element_title' => '',
				'element_caption' => '',
				'num_posts' => '3',
				'num_characters' => '307',
				'category_name' => '',
				'testi_styles' => 'horizontal',
				

			), $atts );
			
			extract( $result );
			

			global $wpdb,$post;
			
			$args = array();
			$category_id = 0;
			

			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'testimonial-category');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$args = array( 
						'post_type' 		=> 'testimonial',
						'posts_per_page' 	=> $num_posts,
						'tax_query' => array(
							array(
								'taxonomy' 	=> 'testimonial-category',
								'terms' 	=> $category_id,
								'field' 	=> 'term_id',
							)
						), 
						'post_status'      	=> 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
				
				}else{
					
					$args = array( 
						'post_type' 		=> 'testimonial',
						'post_status'       => 'publish',
						'posts_per_page' 	=> $num_posts,
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
				}
			
			}else{
			
				$args = array( 
					'post_type' 		=> 'testimonial',
					'post_status'       => 'publish',
					'posts_per_page' 	=> $num_posts,
					'orderby' 			=> 'date',
					'order' 			=> 'ASC'
				);
			
			
			}
			
			query_posts($args);	
			
			if($testi_styles == "horizontal"){
				
				/* Owl Scripts */
				wp_enqueue_script( 'cp-owl', wecare_PATH_URL.'/frontend/js/owl.carousel.min.js', false, '1.0', true);

				wp_enqueue_style('cp-owl',wecare_PATH_URL.'/frontend/css/owl.carousel.css');
				
				$output = '
				
				<section class="donation-row">
				  <div class="element_wrap">
					<div class="row">
					  <div class="col-md-12">
						<div class="testimonials-style-1">
						  <div class="heading-style-1"> 
								<span>'.$element_caption.'</span>
								<h2>'.$element_title.'</h2>
						  </div>
						  <div class="testimonials-box-1">
							<div id="testimonials-1" class="owl-carousel">';
							 
							if ( have_posts() ) {
		
								while ( have_posts() ) { the_post(); global $post;
								
									$designation_text = get_post_meta($post->ID, 'designation_text', true);
									
									if(!empty($num_characters)){
										
										if (strlen(get_the_content()) > $num_characters){
											
											$testimonial_content = mb_substr(get_the_content(), 0, $num_characters);
										
										}else{
											
											$testimonial_content = htmlspecialchars_decode(get_the_content());
										
										}
									
									}else{
										
										$testimonial_content = htmlspecialchars_decode(get_the_content());
									}
							
									$output .= '
									
									<div class="item"> 
										<em>'.$testimonial_content.'</em>
										<div class="thumb">'.get_the_post_thumbnail($post->ID, array(83,83)).'</div>
										<div class="text-col">
										  <h3>'.get_the_title().'</h3>
										  <span>'.$designation_text.'</span> 
										</div>
									</div>';
									
								} wp_reset_query();
							}
							$output .= '
							</div>
						  </div>
						</div>
					  </div>
					</div>
				  </div>
				</section>';
						
				
			}
			
			if($testi_styles == "vertical2"){
				
				/* Bx Slider Script and CSS file  */
			
				wp_enqueue_style('cp-bx-slider',wecare_PATH_URL.'/frontend/css/jquery.bxslider.css');
				
				wp_enqueue_script( 'cp-bx-slider', wecare_PATH_URL.'/frontend/js/jquery.bxslider.min.js', false, '1.0', true);
				
				/* Single Image */
				
				$bg_image = wpb_getImageBySize( array( 'attach_id' => $bg_image, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
				
				$bg_image =  $bg_image['p_img_large'][0];
				
				$inline_style = '';
				
				$inline_style = '<style>.testimonial-style-2 .holder{ background: url('.esc_url($bg_image).') no-repeat left top/cover;}</style>';
				
				$output = $inline_style.'
				
				<section class="testimonial-style-2 testimonial-space-3 testimonial-bg">
				  <div class="element_wrap">
					<div class="holder">
					  <div id="testimonial-2">';
						  
							if ( have_posts() ) {
		
								while ( have_posts() ) { the_post(); global $post;
								
									$designation_text = get_post_meta($post->ID, 'designation_text', true);
									
									if(!empty($num_characters)){
										
										if (strlen(get_the_content()) > $num_characters){
											
											$testimonial_content = mb_substr(get_the_content(), 0, $num_characters);
										
										}else{
											
											$testimonial_content = htmlspecialchars_decode(get_the_content());
										
										}
									
									}else{
										
										$testimonial_content = htmlspecialchars_decode(get_the_content());
									}
							
									$output .= '
									
										<div class="slide">
										  <div class="clearfix"> 
										  <em>'.strip_tags($testimonial_content).'</em>
											<div class="btn-row">
											  <div class="thumb">'.get_the_post_thumbnail($post->ID, array(100,100)).'</div>
											  <div class="holde">
												<h4>'.get_the_title().' </h4>
												<span class="disp">'.$designation_text.'</span> 
											  </div>
											</div>
										  </div>
										</div>';
		
								} wp_reset_query(); /* endwhile */
							}
		
							$output .= '
						</div>
					  </div>
				  </div>
				</section>';
				
			}
			
			if($testi_styles == "dual"){
				
				/* Owl Scripts */
				wp_enqueue_script( 'cp-owl', wecare_PATH_URL.'/frontend/js/owl.carousel.min.js', false, '1.0', true);

				wp_enqueue_style('cp-owl',wecare_PATH_URL.'/frontend/css/owl.carousel.css');
				
				/* Single Image */
				
				$bg_image = wpb_getImageBySize( array( 'attach_id' => $bg_image, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
				
				$bg_image =  $bg_image['p_img_large'][0];
				
				$inline_style = '';
				
				$inline_style = '<style>.testimonial-style-3-box-bg{ background: url('.esc_url($bg_image).') no-repeat left top/cover;}</style>';
				
				$output = $inline_style.'
				
				<div class="testimonials-style-1 testimonials-style-2">
				  <div class="element_wrap">
					<div id="testimonials-2" class="owl-carousel">';
						  
							if ( have_posts() ) {
		
								while ( have_posts() ) { the_post(); global $post;
								
									$designation_text = get_post_meta($post->ID, 'designation_text', true);
									
									if(!empty($num_characters)){
										
										if (strlen(get_the_content()) > $num_characters){
											
											$testimonial_content = mb_substr(get_the_content(), 0, $num_characters);
										
										}else{
											
											$testimonial_content = htmlspecialchars_decode(get_the_content());
										
										}
									
									}else{
										
										$testimonial_content = htmlspecialchars_decode(get_the_content());
									}
							
									$output .= '
									
									<div class="item">
										<div class="testimonials-box-1"> 
											<em>'.strip_tags($testimonial_content).'</em>
											<div class="thumb">'.get_the_post_thumbnail($post->ID, array(83,83)).'</div>
											<div class="text-col">
												<h3>'.get_the_title().'</h3>
												<span>'.$designation_text.'</span> 
											</div>
										</div>
									</div>';
									
										
								} wp_reset_query(); /* endwhile */
							}
		
							$output .= '
					</div>
				  </div>
				</div>';
				
			}

				
			return $output;
		
			wp_reset_postdata();
		} /* end of function */
	} /* end of class */
	
	new wecare_testimonials_slider;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_testimonials_slider extends WPBakeryShortCode {
		}
	}
}