<?php

	/*	
	*	CrunchPress Include Script File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	*   @ Package   CrunchPress
	* 	@author		CrunchPress
	* 	@link		http://crunchpress.com
	* 	@copyright	Copyright (c) CrunchPress
	*	---------------------------------------------------------------------
	*	This file manage to embed the stylesheet and javascript to each page
	*	based on the content of that page.
	*	---------------------------------------------------------------------
	*/
	
	/* Add Scripts in Theme */
	if(is_admin()){
		add_action('admin_enqueue_scripts', 'wecare_register_meta_script');
		add_action('admin_enqueue_scripts','wecare_register_crunchpress_panel_scripts');
		add_action('admin_enqueue_scripts','wecare_register_crunchpress_panel_styles');
	}else{
		add_action('wp_enqueue_scripts','wecare_register_non_admin_styles');
		add_action('wp_enqueue_scripts','wecare_register_non_admin_scripts');

	}

	
	/* 	---------------------------------------------------------------------
	*	This section include the back-end script
	*	---------------------------------------------------------------------
	*/ 
	
	function wecare_register_meta_script(){
		
		global $post_type;
		
		wp_enqueue_style('bootstrap', wecare_PATH_URL.'/framework/stylesheet/bootstrap.css');
		
		wp_enqueue_style('thickbox');
		
		/* Font Awesome */
		
		wp_enqueue_style('font-awesome',wecare_PATH_URL.'/frontend/font-awesome/font-awesome.min.css');
		
		wp_enqueue_style('admin-css',wecare_PATH_URL.'/framework/stylesheet/admin-css.css');
		
		/* register style and script when access to the "page" post_type page */
		
		if( $post_type == 'page' ){
		
			wp_enqueue_style('meta-css',wecare_PATH_URL.'/framework/stylesheet/meta-css.css');
			
			wp_enqueue_style('page-dragging',wecare_PATH_URL.'/framework/stylesheet/page-dragging.css');
			
			wp_enqueue_style('image-picker',wecare_PATH_URL.'/framework/stylesheet/image-picker.css');
			
			wp_enqueue_script( 'image-picker', wecare_PATH_URL.'/framework/javascript/image-picker.js', false, '1.0', true);
			
			wp_enqueue_script( 'page-dragging', wecare_PATH_URL.'/framework/javascript/page-dragging.js', false, '1.0', true);
		
			wp_enqueue_script( 'edit-box', wecare_PATH_URL.'/framework/javascript/edit-box.js', false, '1.0', true);
			
			wp_enqueue_script( 'confirm-dialog', wecare_PATH_URL.'/framework/javascript/jquery.confirm.js', false, '1.0', true);
			
			
	
		/*  register style and script when access to the "post" post_type page */
		}else if( $post_type == 'event' || $post_type == 'post' || $post_type == 'team'  || $post_type == 'portfolio' || $post_type == 'wecare_slider' || $post_type == 'gallery' || $post_type == 'product' ){
		
			wp_deregister_style('admin-css');
			
			wp_enqueue_style('meta-css',wecare_PATH_URL.'/framework/stylesheet/meta-css.css');
			
			wp_enqueue_style('image-picker',wecare_PATH_URL.'/framework/stylesheet/image-picker.css');
			
			wp_enqueue_style('confirm-dialog',wecare_PATH_URL.'/framework/stylesheet/jquery.confirm.css');
			
			wp_enqueue_script( 'post-effects', wecare_PATH_URL.'/framework/javascript/post-effects.js', false, '1.0', true);
			
			wp_enqueue_script( 'image-picker', wecare_PATH_URL.'/framework/javascript/image-picker.js', false, '1.0', true);
			
			wp_localize_script('image-picker', 'URL', array('wecare' => wecare_PATH_URL ));
			
			wp_enqueue_script( 'confirm-dialog', wecare_PATH_URL.'/framework/javascript/jquery.confirm.js', false, '1.0', true);
		
		/* register style and script when access to the "testimonial" post_type page */
		
		}else if( $post_type == 'testimonial' ){
		
			wp_enqueue_style('meta-css',wecare_PATH_URL.'/framework/stylesheet/meta-css.css');
		
		}
		
	}
	
	
	/* register script in CrunchPress panel */
	function wecare_register_crunchpress_panel_scripts(){
		
		global $post_type;
		
		if($post_type == 'page'){
		
		}else{
			
			wp_enqueue_style('bootstrap',wecare_PATH_URL.'/framework/stylesheet/bootstrap.css');
			
			$wecare_script_url = wecare_PATH_URL.'/framework/javascript/cp-panel.js';
			
			wp_enqueue_script('wecare_scripts_admin', $wecare_script_url, array('jquery','media-upload','cp-bootstrap','thickbox', 'jquery-ui-droppable','jquery-ui-datepicker','jquery-ui-tabs', 'jquery-ui-slider','jquery-timepicker','jquery-ui-position','mini-color','confirm-dialog','dummy_content'));

			wp_enqueue_script( 'cp-bootstrap', wecare_PATH_URL.'/framework/javascript/bootstrap.js', false, '1.0', true);
			
			/* Font Awesome */
			wp_enqueue_style('font-awesome',wecare_PATH_URL.'/frontend/wecare_font/css/font-awesome.css');
			
			wp_enqueue_style('font-awesome',wecare_PATH_URL.'/frontend/wecare_font/css/font-awesome-ie7.css');

			wp_enqueue_script('mini-color', wecare_PATH_URL.'/framework/javascript/jquery.miniColors.js', false, '1.0', true);
			
			wp_enqueue_script('confirm-dialog', wecare_PATH_URL.'/framework/javascript/jquery.confirm.js', false, '1.0', true);
			
			wp_enqueue_script('jquery-timepicker', wecare_PATH_URL.'/framework/javascript/jquery.ui.timepicker.js', false, '1.0', true);
			
			wp_enqueue_script('dummy_content', wecare_PATH_URL.'/framework/javascript/dummy_content.js', false, '1.0', true);
		}		
	}

	/* register style in CrunchPress panel */
	function wecare_register_crunchpress_panel_styles(){
	
		wp_enqueue_style('jquery-ui',wecare_PATH_URL.'/framework/stylesheet/jquery-ui.css');
		
		wp_enqueue_style('cp-panel',wecare_PATH_URL.'/framework/stylesheet/cp-panel.css');
		
		wp_enqueue_style('mini-color',wecare_PATH_URL.'/framework/stylesheet/jquery.miniColors.css');
		
		wp_enqueue_style('confirm-dialog',wecare_PATH_URL.'/framework/stylesheet/jquery.confirm.css');
		
		wp_enqueue_style('jquery-timepicker',wecare_PATH_URL.'/framework/stylesheet/jquery.ui.timepicker.css');
		
	}
	
	/* 	---------------------------------------------------------------------
	*	this section include the front-end script
	*	---------------------------------------------------------------------
	*/ 
	
	/* Register all stylesheet */

	function wecare_register_non_admin_styles(){
	
		$wecare_page_xml = '';
		
		$wecare_slider_type = '';
	
		global $post,$post_id,$wecare_page_xml,$wecare_slider_type;
		
		$wecare_page_xml = get_post_meta($post_id,'page-option-item-xml', true);
		
		$wecare_slider_type = get_post_meta ( $post_id, "page-option-top-slider-types", true );

		
		/* Default Stylesheet */
		wp_enqueue_style( 'default-style', get_stylesheet_uri() );  

		
		/* Widgets CSS */
		wp_enqueue_style('cp-widgets',wecare_PATH_URL.'/frontend/css/widgets.css');

		/* Responsive CSS */
		wp_enqueue_style('responsive-css',wecare_PATH_URL.'/frontend/css/responsive.css');
		
		/* Woocommerce CSS */
		wp_enqueue_style('custom-woostyle',wecare_PATH_URL.'/frontend/css/wp-commerce.css');
		
		/* modernizr */
		wp_enqueue_script('cp-scripts_modernizr', wecare_PATH_URL.'/frontend/js/modernizr.min.js', false, '1.0', true);

		/* All Scripts */
		wp_enqueue_script( 'custom-scripts', wecare_PATH_URL.'/frontend/js/custom.js', false, '1.0', true);

		/* Bootstrap Css */
		wp_enqueue_style('cp-bootstrap',wecare_PATH_URL.'/frontend/css/bootstrap.min.css');
		
		/* Animate CSS */
		wp_enqueue_style('cp-animate',wecare_PATH_URL.'/frontend/css/animate.css');
		
		/* SVG CSS */
		wp_enqueue_style('cp-svg',wecare_PATH_URL.'/frontend/css/svg.css');
		
		/* Form CSS */
		wp_enqueue_style('cp-form',wecare_PATH_URL.'/frontend/css/form.css');
		
		/* Pretty Photo Scripts */	
		wp_enqueue_style('prettyPhoto',wecare_PATH_URL.'/frontend/css/prettyphoto.min.css');
			
		wp_enqueue_script('prettyPhoto', wecare_PATH_URL.'/frontend/js/jquery.prettyphoto.min.js', false, '1.0', true);

		/* Font Awesome CSS */
		wp_enqueue_style('font-awesome',wecare_PATH_URL.'/frontend/font-awesome/font-awesome.min.css');
	
		
		$wecare_rtl_layout = '';
		$wecare_site_loader = '';
		$wecare_element_loader = '';
		//General Settings Values
		$wecare_general_settings = get_option('general_settings');
		if($wecare_general_settings <> ''){
			$wecare_logo = new DOMDocument ();
			$wecare_logo->loadXML ( $wecare_general_settings );
			$wecare_rtl_layout = wecare_find_xml_value($wecare_logo->documentElement,'rtl_layout');
			$wecare_site_loader = wecare_find_xml_value($wecare_logo->documentElement,'site_loader');
			$wecare_element_loader = wecare_find_xml_value($wecare_logo->documentElement,'element_loader');
		}
		
		wp_deregister_style('woocommerce-general');
		wp_deregister_style('ls-google-fonts-css');
		wp_deregister_style('woocommerce-layout');
		wp_deregister_style('woocommerce_frontend_styles');		
		wp_deregister_style('events-manager');		
		wp_deregister_style('mm_font-awesome');		
		
		
		/* RTL Layouts */
		if($wecare_rtl_layout == 'enable'){
			
			wp_enqueue_style('cp-rtl',wecare_PATH_URL.'/rtl.css');
		}		
		
		if(isset($post)){
			
			$content = strip_tags(get_the_content());
		}
		
		
		/* Widget Active */
		if(is_active_widget( '', '', 'twitter_widget')){			
			
			/* If widget is active then enqueue */
		}

		
		/* is search or archive */
		if( is_search() || is_archive() ){
			
			/* yet to be implemented */
	
		/* Post post_type */
		}else if( isset($post) && $post->post_type == 'post' || isset($post) && $post->post_type == 'event' ){

			if(!is_home()){
					
				$thumbnail_types = '';
				
				$post_detail_xml = get_post_meta($post->ID, 'post_detail_xml', true);
				
				if($post_detail_xml <> ''){
					
					$wecare_post_xml = new DOMDocument ();
					
					$wecare_post_xml->loadXML ( $post_detail_xml );
					
					$thumbnail_types = wecare_find_xml_value($wecare_post_xml->documentElement,'post_thumbnail');
					
					if( $thumbnail_types == 'Slider'){
				
						wp_enqueue_style('cp-bx-slider',wecare_PATH_URL.'/frontend/css/bxslider.css');
						
					}
				}
					

				$event_detail_xml = get_post_meta($post->ID, 'event_detail_xml', true);
				
				if($event_detail_xml <> ''){
						
					$wecare_event_xml = new DOMDocument ();
						
					$wecare_event_xml->loadXML ( $event_detail_xml );
					
					$event_thumbnail = wecare_find_xml_value($wecare_event_xml->documentElement,'event_thumbnail');
						
					wp_enqueue_style('cp-countdown',wecare_PATH_URL.'/frontend/css/jquery.countdown.css'); /* load countdown */		
						
				}
					
			}
								
			/* Page post_type */

		}else if( isset($post) && $post->post_type == 'page' ){
		
			global $post,$wecare_page_xml, $wecare_slider_type, $wecare_top_slider_type;
			$wecare_page_xml = get_post_meta($post->ID,'page-option-item-xml', true);
			$wecare_top_slider_switch = get_post_meta($post->ID,'page-option-top-slider-on', true);
			$wecare_slider_type = get_post_meta ( $post->ID, "page-option-top-slider-types", true );
			$wecare_top_slider_type = get_post_meta($post->ID,'page-option-top-slider-types', true);

			/* detect element, then enqueue the script or style */
		}
		
		$font_google = '';
		$font_size_normal = '';
		$menu_font_google = '';
		$fonts_array = '';
		$font_google_heading = '';
		$heading_h1 = '';
		$heading_h2 = '';
		$heading_h3 = '';
		$heading_h4 = '';
		$heading_h5 = '';
		$heading_h6 = '';
		$embed_typekit_code = '';
		$wecare_typography_settings = get_option('typography_settings');
		
		
		if($wecare_typography_settings <> ''){
			$wecare_typo = new DOMDocument ();
			$wecare_typo->loadXML ( $wecare_typography_settings );
			$font_google = wecare_find_xml_value($wecare_typo->documentElement,'font_google');
			$font_size_normal = wecare_find_xml_value($wecare_typo->documentElement,'font_size_normal');
			$menu_font_google = wecare_find_xml_value($wecare_typo->documentElement,'menu_font_google');
			$font_google_heading = wecare_find_xml_value($wecare_typo->documentElement,'font_google_heading');
			$heading_h1 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h1');
			$heading_h2 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h2');
			$heading_h3 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h3');
			$heading_h4 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h4');
			$heading_h5 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h5');
			$heading_h6 = wecare_find_xml_value($wecare_typo->documentElement,'heading_h6');
			$embed_typekit_code = wecare_find_xml_value($wecare_typo->documentElement,'embed_typekit_code');
			
		}
		
		/* Body Font Installing */
		if(wecare_get_font_type($font_google) == 'Google_Font'){
			/* Google Font Body */
			if($font_google <> ''){
				wp_enqueue_style('googleFonts', wecare_get_google_font_url($font_google));
			}	
		} else{
			/* Adobe Edge Font (TypeKit)  */
			// if($font_google <> ''){
				// wp_register_script( 'adobe-edge-font', "http://use.edgefonts.net/".$font_google.".js", false, '1.0', false);
				// wp_enqueue_script('adobe-edge-font');	
			// }
		}
		
		if(wecare_get_font_type($font_google_heading) == 'Google_Font'){
			if($font_google_heading <> ''){				
				wp_enqueue_style('googleFonts-heading', wecare_get_google_font_url($font_google_heading) );
			}
		}else{
			// if($font_google_heading <> ''){
				// wp_enqueue_script( 'adobe-edge-heading', "http://use.edgefonts.net/".$font_google_heading.".js", false, '1.0', false);
				
			// }
		}

		/* Menu Font Installing	 */
		if(wecare_get_font_type($menu_font_google) == 'Google_Font'){
			if($menu_font_google <> ''){
				wp_enqueue_style('menu-googleFonts-heading', wecare_get_google_font_url($menu_font_google));
			}
		}else{
			// if($menu_font_google <> ''){
				// wp_enqueue_script( 'menu-edge-heading', "http://use.edgefonts.net/".$menu_font_google.".js", false, '1.0', false);
				
			// }
		}
		
	}
		 
    /* Register all scripts */
	function wecare_register_non_admin_scripts(){
		
		global $post,$post_id;
		global $wecare_is_responsive;
		global $crunchpress_element;		
		global $wp_scripts;
		$wecare_is_responsive = 'enable';
		$wecare_page_xml = get_post_meta($post_id,'page-option-item-xml', true);
		$wecare_slider_type = get_post_meta ( $post_id, "page-option-top-slider-types", true );

		$social_networking = '';
		$site_loader = '';
		$element_loader = '';
		$wecare_general_settings = get_option('general_settings');
		
		if($wecare_general_settings <> ''){
			$wecare_logo = new DOMDocument ();
			$wecare_logo->loadXML ( $wecare_general_settings );
			$social_networking = wecare_find_xml_value($wecare_logo->documentElement,'social_networking');
			$site_loader = wecare_find_xml_value($wecare_logo->documentElement,'site_loader');
			$element_loader = wecare_find_xml_value($wecare_logo->documentElement,'element_loader');
			$topweather_icon = wecare_find_xml_value($wecare_logo->documentElement,'topweather_icon');
			
		}
		
		wp_enqueue_script('jquery');
	
		if ( is_singular() && get_option( 'thread_comments' ) ) 	wp_enqueue_script( 'comment-reply' );
			
		/* BootStrap Script Loaded */
		wp_enqueue_script('cp-bootstrap', wecare_PATH_URL.'/frontend/js/bootstrap.min.js', array('jquery'), '1.0', true);
		
		wp_localize_script('cp-bootstrap', 'ajax_var', array('url' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('ajax-nonce')));
		
		/* modernizr */
		wp_enqueue_script('cp-scripts_modernizr', wecare_PATH_URL.'/frontend/js/modernizr.min.js', false, '1.0', true);
		
		
		
		
			
		if(isset($post)){
			
			$content = strip_tags(get_the_content($post_id));
			
			/* Yet to be implemented */
		}
		
		global $wp_scripts,$post;
		
		wp_enqueue_script('html5shiv',wecare_PATH_URL.'/frontend/js/html5shive.js',array(),'1.5.1',false);
		
		$wp_scripts->add_data( 'html5shiv', 'conditional', 'lt IE 9' );		
					
		
		
		/* Search and archive page */
		if( is_search() || is_archive() ){
		
			/* Yet to be implemented */
		
		/* Post post_type */
		}else if(isset($post) && $post->post_type == 'timeline' ){
		
			/* Yet to be implemented */
					
		}else if(isset($post) && $post->post_type == 'ignition_product' ){
		
			wp_enqueue_script('cp-progressjs', wecare_PATH_URL.'/frontend/js/progress.js', false, '1.0', true);
					
		}else if( isset($post) &&  $post->post_type == 'sermons' && !is_home()){
		
			/* Yet to be implemented */

		}else if(isset($post) &&  $post->post_type == 'event' && !is_home()){
		
			wp_enqueue_script('cp-plugin', wecare_PATH_URL.'/frontend/js/jquery.plugin.min.js', false, '1.0', true);
		
			wp_enqueue_style('cp-countdowncs',wecare_PATH_URL.'/frontend/css/jquery.countdown.css');
		
			wp_enqueue_script('cp-countdown', wecare_PATH_URL.'/frontend/js/jquery.countdown.js', false, '1.0', true);
			
			/* Pretty Photo Scripts */
			
			wp_enqueue_style('prettyPhoto',wecare_PATH_URL.'/frontend/css/prettyphoto.min.css');
			
			wp_enqueue_script('prettyPhoto', wecare_PATH_URL.'/frontend/js/jquery.prettyphoto.min.js', false, '1.0', true);
			
		
		}else if(isset($post) &&  $post->post_type == 'service' && !is_home()){
		
			/* Yet to be implemented */
			
		}else if(isset($post) &&  $post->post_type == 'post' && !is_home() ){
		
			/* Yet to be implemented */
		
		/*  Page post_type */
		}else if( isset($post) &&  $post->post_type == 'page' ){
			
			global $post,$wecare_page_xml, $wecare_slider_type, $wecare_top_slider_type;
			$wecare_page_xml = get_post_meta($post->ID,'page-option-item-xml', true);
			$wecare_top_slider_switch = get_post_meta($post->ID,'page-option-top-slider-on', true);
			$wecare_slider_type = get_post_meta ( $post->ID, "page-option-top-slider-types", true );
			$wecare_top_slider_type = get_post_meta($post->ID,'page-option-top-slider-types', true);
			$paraluxx = get_post_meta($post->ID,'page-option-attachment-bg-cp', true);

			/* Yet to be implemented */
		}
	}

?>