<?php 
/* Condition for Parent Class */
if(class_exists('wecare_function_library')){
	
	add_action( 'plugins_loaded', 'wecare_fun_override' );
	
	function wecare_fun_override() {
		
		$wecare_class = new wecare_arkeytect;
	}

	class wecare_arkeytect extends wecare_function_library{
		
		public $wecare_array = array(
		
			/* Yet To Be Implemented */
			
		);
		
		public $speakers_array = array(
		
			/* Yet To Be Implemented */		
			
		);
		

		
		public function page_builder_size_class(){
		
		
		}
		
		public function page_builder_element_class(){
		
			global $page_meta_boxes;
				
				/* Yet To Be Implemented */
		}
		
		public function wecare_wecare_init(){
			
			/* Yet To Be Implemented */
			
		}
		
		/* Constructor */
		public function __construct(){
			
			add_action( 'init', array( $this, 'wecare_create_arkeytect' ) );
			add_action( 'add_meta_boxes', array( $this, 'wecare_add_wecare_option' ) );
			add_action( 'save_post', array( $this, 'save_wecare_option_meta' ) );
		}
		
		public function wecare_create_arkeytect() {
			
			$labels = array(
				'name' => _x('Projects', 'Projects General Name', 'eventco'),
				'singular_name' => _x('Project', 'Event Singular Name', 'eventco'),
				'add_new' => _x('Add New', 'Add New Projects', 'eventco'),
				'add_new_item' => __('Add New Project', 'eventco'),
				'edit_item' => __('Edit Project', 'eventco'),
				'new_item' => __('New Project', 'eventco'),
				'view_item' => __('View Project', 'eventco'),
				'search_items' => __('Search Projects', 'eventco'),
				'not_found' =>  __('Nothing found', 'eventco'),
				'not_found_in_trash' => __('Nothing found in Trash', 'eventco'),
				'parent_item_colon' => ''
			);
			
			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'query_var' => true,
				'menu_icon' => 'dashicons-tagcloud',
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 100,
				'supports' => array('title','editor','author','thumbnail','excerpt','comments'),
				'has_archive' => true,
				'rewrite' => array('slug' => '', 'with_front' => false)
			  ); 
			  
			register_post_type( 'projects' , $args);	

			register_taxonomy(
				"projects-categories", array("projects"), array(
					"hierarchical" => true,
					"label" => "Project Categories", 
					"singular_label" => "Project Categories", 
					"rewrite" => true));
			register_taxonomy_for_object_type('projects-categories', 'projects');

			register_taxonomy(
				'projects-tags',
				'projects',
				array(
					'hierarchical'  => false,
					'label'         => "Project Tags",
					'singular_name' => "Project Tag",
					'rewrite'       => true,
					'query_var'     => true
				)
			);	
						
		}
		
		
		
		public function wecare_add_wecare_option(){	
		
			add_meta_box('team-option', __('Our Projects Options','wecare'), array($this,'wecare_add_our_wecare_element'),
				'projects', 'normal', 'high');
				
		}
		

		public function wecare_add_our_wecare_element(){
			
			$wecare_social = '';
			$sidebar_ecoist = '';
			$right_sidebar_ecoist = '';
			$left_sidebar_ecoist = '';
			$projects_icons = '';
			$projects_duration = '';
			
		

		foreach($_REQUEST as $keys=>$values){
			$$keys = $values;
		}
		global $post;
	
		$wecare_projects_detail_xml = get_post_meta($post->ID, 'wecare_projects_detail_xml', true);
		
		if($wecare_projects_detail_xml <> ''){
			
			$wecare_wecare_wecare_xml = new DOMDocument ();
			
			$wecare_wecare_wecare_xml->loadXML ( $wecare_projects_detail_xml );
			
			$wecare_social = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'wecare_social');
			$sidebar_ecoist = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'sidebar_ecoist');
			$left_sidebar_ecoist = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'left_sidebar_ecoist');
			$right_sidebar_ecoist = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'right_sidebar_ecoist');
			$projects_icons = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'projects_icons');
			$projects_duration = wecare_function_library::wecare_find_xml_value($wecare_wecare_wecare_xml->documentElement,'projects_duration');
			
	
		}
		?>

        	<div class="event_options project_options">
            <div class="op-gap">
				<ul class="panel-body recipe_class row-fluid">
					<li class="panel-input span12">
						<span class="panel-title">
							<h3 for="wecare_social" > <?php esc_html_e('Social Networking', 'wecare'); ?> </h3>
						</span>	
						
						<label for="wecare_social"><div class="checkbox-switch <?php
						
						echo ($wecare_social=='enable' || ($wecare_social=='' && empty($default)))? 'checkbox-switch-on': 'checkbox-switch-off'; 

					?>"></div></label>
					<input type="checkbox" name="wecare_social" class="checkbox-switch" value="disable" checked>
					<input type="checkbox" name="wecare_social" id="wecare_social" class="checkbox-switch" value="enable" <?php 
						
						echo ($wecare_social=='enable' || ($wecare_social=='' && empty($default)))? 'checked': ''; 
					
					?>>
					<p><?php esc_html_e('Turn On/Off Social Sharing.', 'wecare'); ?></p>
					</li>
				</ul>
				<div class="clear"></div>
				<?php echo wecare_function_library::wecare_show_sidebar($sidebar_ecoist,'right_sidebar_ecoist','left_sidebar_ecoist',$right_sidebar_ecoist,$left_sidebar_ecoist);?>
				<div class="row-fluid">
					<div class="span6">
						<ul class="panel-body recipe_class">
							<li class="panel-input">
								<span class="panel-title">
									<h3 for="projects_icons" > <?php esc_html_e('Font Awesome Icon', 'wecare'); ?> </h3>
								</span>
								<input type="text" name="projects_icons" id="projects_icons" value="<?php if($projects_icons <> ''){echo $projects_icons;};?>" />
								<p><?php esc_html_e('Please Enter Font Awesome Icon Here, i.e fa fa-globe', 'wecare'); ?></p>
							</li>
						</ul>
					</div>
					<div class="span6">
						<ul class="panel-body recipe_class">
							<li class="panel-input">
								<span class="panel-title">
									<h3 for="projects_duration" > <?php esc_html_e('Duration', 'wecare'); ?> </h3>
								</span>
								<input type="text" name="projects_duration" id="projects_duration" value="<?php if($projects_duration <> ''){echo $projects_duration;};?>" />
								<p><?php esc_html_e('Please Enter Duration of Completed Project, i.e 2004-2009', 'wecare'); ?></p>
							</li>
						</ul>
					</div>
				</div>
				<div class="clear"></div>
				<input type="hidden" name="wecare_submit" value="projects"/>
				<div class="clear"></div>
			</div>	
        </div>	
			
        <?php }
		
		public function save_wecare_option_meta($post_id){
			
			$wecare_social = '';
			$sidebars = '';
			$right_sidebar_ecoist = '';
			$left_sidebar_ecoist = '';
			$projects_icons = '';
		

			foreach($_REQUEST as $keys=>$values){
				$$keys = $values;
			}
		
			if(defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE) return;
		
				if(isset($wecare_submit) AND $wecare_submit == 'projects'){
					$new_data = '<wecare_wecare_detail>';
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('wecare_social',$wecare_social);
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('sidebar_ecoist',$sidebars);
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('right_sidebar_ecoist',$right_sidebar_ecoist);
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('left_sidebar_ecoist',$left_sidebar_ecoist);
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('projects_icons',$projects_icons);
					$new_data = $new_data . wecare_function_library::wecare_create_xml_tag('projects_duration',$projects_duration);
					
		
					$new_data = $new_data . '</wecare_wecare_detail>';
				
				/* Saving Sidebar and Social Sharing Settings as XML */
				$old_data = get_post_meta($post_id, 'wecare_projects_detail_xml',true);
				wecare_function_library::wecare_save_meta_data($post_id, $new_data, $old_data, 'wecare_projects_detail_xml');

			}
		}	

	}
}