<?php 
/* custom post type for Awards */
function wecare_award() {
			
			$labels = array(
				'name' => _x('Awards', 'Awards General Name', 'wecare'),
				'singular_name' => _x('Award', 'Award Singular Name', 'wecare'),
				'add_new' => _x('Add New', 'Add New Award Name', 'wecare'),
				'add_new_item' => __('Add New Award', 'wecare'),
				'edit_item' => __('Edit Award', 'wecare'),
				'new_item' => __('New Award', 'wecare'),
				'view_item' => __('View Award', 'wecare'),
				'search_items' => __('Search Award', 'wecare'),
				'not_found' =>  __('Nothing found', 'wecare'),
				'not_found_in_trash' => __('Nothing found in Trash', 'wecare'),
				'parent_item_colon' => ''
			);
			
			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'query_var' => true,
				'menu_icon' => 'dashicons-awards',
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 100,
				'supports' => array('title','editor','author','thumbnail','comments'),
				'has_archive' => true,
				'rewrite' => array('slug' => '', 'with_front' => false)
			  ); 
			  
			register_post_type( 'award' , $args);	

			register_taxonomy(
				"award-category", array("award"), array(
					"hierarchical" => true,
					"label" => "Award Categories", 
					"singular_label" => "Award Category", 
					"rewrite" => true));
			register_taxonomy_for_object_type('award-category', 'award');			
		}
		
		add_action( 'init', 'wecare_award' );

?>